% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_api.R
\name{route_add}
\alias{route_add}
\alias{route_remove}
\alias{route_get}
\title{Route handlers}
\usage{
route_add(x, method, path, handler)

route_remove(x, method, path)

route_get(x, method, path)
}
\arguments{
\item{x}{A \link{Route} object}

\item{method}{A request method for the handler. The special method \code{"all"}
will allow the handler to match all http request methods that comes in.}

\item{path}{A URL path for the handler. See Paths for more on path
semantics}

\item{handler}{A handler function. See Handlers for more about the semantics
of handlers}
}
\value{
\code{x}, modified. \code{route_get()} returns the requested handler
}
\description{
These functions helps you to add, remove, and retrieve route handlers. They
all (except for \code{route_get()}) returns the route for easy chaining.
}
\section{Paths}{
The path is a URL path consisting of strings, parameters (strings prefixed
with \code{:}), and wildcards (\code{*}), separated by \code{/}. A wildcard will match
anything and is thus not restricted to a single path element (i.e. it will
span multiple \code{/} if possible). When serving a request only a single handler
is selected based on the path match that is most specific. Specificity is
based on number of path parts (ie. number of elements separated by \code{/}), the
more the better; number of wildcards, the fewer the better; and number of
keys, the fewer the better. When printing the route you can see the priority
of all the paths in the route as they are sorted by that
}

\section{Handlers}{
The handler is a function. At the very least it should have a \code{...} argument
and it must return eiter \code{TRUE} or \code{FALSE}. Returning \code{TRUE} means that the
request is allowed to continue processing and can be passed on to the next
route in the stack. Returning \code{FALSE} stops the processing of the request by
the stack.

While any arguments besides \code{...} are optional, there are a few that will get
passed in named:
\itemize{
\item \code{request} will hold the request as a \link[reqres:Request]{reqres::Request} object
\item \code{response} will hold the request as a \link[reqres:Response]{reqres::Response} object
\item \code{keys} will be a named list containing the values of the matched path keys
(see example)
}

Further, if routr is used as a fiery plugin, the handler will receive:
\itemize{
\item \code{server} is the \code{fiery::Fire} object defining the app
\item \code{id} is the id of the client sending the request, as provided by fiery
\item \code{arg_list} is a list of values as calculated by the servers \code{before-request}
event handlers
}

Any and all of the above can be ignored by your handler, but accepting the
\code{server} is often paramount to more powerful features such as delayed
execution or logging.
}

\examples{
\dontshow{if (packageVersion("base") >= "4.1.0") withAutoprint(\{ # examplesIf}
# Add a handler
route <- route() |>
  route_add("get", "/:what", function(request, response, keys, ...) {
    message("Requesting", keys$what)
    TRUE
  })
route

# Retrieve the handler
route |> route_get("get", "/:what")

# Remove the handler
route |> route_remove("get", "/:what")
\dontshow{\}) # examplesIf}
}
