% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_group_sequential.R
\name{getDesignGroupSequential}
\alias{getDesignGroupSequential}
\title{Get Design Group Sequential}
\usage{
getDesignGroupSequential(
  ...,
  kMax = NA_integer_,
  alpha = NA_real_,
  beta = NA_real_,
  sided = 1L,
  informationRates = NA_real_,
  futilityBounds = NA_real_,
  typeOfDesign = c("OF", "P", "WT", "PT", "HP", "WToptimum", "asP", "asOF", "asKD",
    "asHSD", "asUser", "noEarlyEfficacy"),
  deltaWT = NA_real_,
  deltaPT1 = NA_real_,
  deltaPT0 = NA_real_,
  optimizationCriterion = c("ASNH1", "ASNIFH1", "ASNsum"),
  gammaA = NA_real_,
  typeBetaSpending = c("none", "bsP", "bsOF", "bsKD", "bsHSD", "bsUser"),
  userAlphaSpending = NA_real_,
  userBetaSpending = NA_real_,
  gammaB = NA_real_,
  bindingFutility = NA,
  betaAdjustment = NA,
  constantBoundsHP = 3,
  twoSidedPower = NA,
  delayedInformation = NA_real_,
  tolerance = 1e-08
)
}
\arguments{
\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{kMax}{The maximum number of stages \code{K}. 
Must be a positive integer of length 1 (default value is \code{3}).
The maximum selectable \code{kMax} is \code{20} for group sequential or inverse normal and
\code{6} for Fisher combination test designs.}

\item{alpha}{The significance level alpha, default is \code{0.025}. Must be a positive numeric of length 1.}

\item{beta}{Type II error rate, necessary for providing sample size calculations 
(e.g., \code{\link[=getSampleSizeMeans]{getSampleSizeMeans()}}), beta spending function designs, 
or optimum designs, default is \code{0.20}. Must be a positive numeric of length 1.}

\item{sided}{Is the alternative one-sided (\code{1}) or two-sided (\code{2}), default is \code{1}. Must be a positive integer of length 1.}

\item{informationRates}{The information rates (that must be fixed prior to the trial), 
default is \code{(1:kMax) / kMax}.}

\item{futilityBounds}{The futility bounds, defined on the test statistic z scale
(numeric vector of length \code{kMax - 1}).}

\item{typeOfDesign}{The type of design. Type of design is one of the following: 
O'Brien & Fleming (\code{"OF"}), Pocock (\code{"P"}), Wang & Tsiatis Delta class (\code{"WT"}), 
Pampallona & Tsiatis (\code{"PT"}), Haybittle & Peto ("HP"), 
Optimum design within Wang & Tsiatis class (\code{"WToptimum"}), 
O'Brien & Fleming type alpha spending (\code{"asOF"}), Pocock type alpha spending (\code{"asP"}), 
Kim & DeMets alpha spending (\code{"asKD"}), Hwang, Shi & DeCani alpha spending (\code{"asHSD"}), 
user defined alpha spending (\code{"asUser"}), no early efficacy stop (\code{"noEarlyEfficacy"}), 
default is \code{"OF"}.}

\item{deltaWT}{Delta for Wang & Tsiatis Delta class.}

\item{deltaPT1}{Delta1 for Pampallona & Tsiatis class rejecting H0 boundaries.}

\item{deltaPT0}{Delta0 for Pampallona & Tsiatis class rejecting H1 boundaries.}

\item{optimizationCriterion}{Optimization criterion for optimum design within
Wang & Tsiatis class (\code{"ASNH1"}, \code{"ASNIFH1"},
\code{"ASNsum"}), default is \code{"ASNH1"}, see details.}

\item{gammaA}{Parameter for alpha spending function.}

\item{typeBetaSpending}{Type of beta spending. Type of of beta spending is one of the following:
O'Brien & Fleming type beta spending, Pocock type beta spending,
Kim & DeMets beta spending, Hwang, Shi & DeCani beta spending, user defined
beta spending (\code{"bsOF"}, \code{"bsP"}, \code{"bsKD"},
\code{"bsHSD"}, \code{"bsUser"}, default is \code{"none"}).}

\item{userAlphaSpending}{The user defined alpha spending. 
Numeric vector of length \code{kMax} containing the cumulative 
alpha-spending (Type I error rate) up to each interim stage: \code{0 <= alpha_1 <= ... <= alpha_K <= alpha}.}

\item{userBetaSpending}{The user defined beta spending. Vector of length \code{kMax} containing the cumulative
beta-spending up to each interim stage.}

\item{gammaB}{Parameter for beta spending function.}

\item{bindingFutility}{Logical. If \code{bindingFutility = TRUE} is specified the calculation of 
the critical values is affected by the futility bounds and the futility threshold is binding in the 
sense that the study must be stopped if the futility condition was reached (default is \code{FALSE}).}

\item{betaAdjustment}{For two-sided beta spending designs, if \code{betaAdjustement = TRUE} a linear
adjustment of the beta spending values is performed if an overlapping of decision regions for futility
stopping at earlier stages occurs, otherwise no adjustment is performed (default is \code{TRUE}).}

\item{constantBoundsHP}{The constant bounds up to stage \code{kMax - 1} for the
Haybittle & Peto design (default is \code{3}).}

\item{twoSidedPower}{For two-sided testing, if \code{twoSidedPower = TRUE} is specified
the sample size calculation is performed by considering both tails of the distribution.
Default is \code{FALSE}, i.e., it is assumed that one tail probability is equal to 0 or the power
should be directed to one part.}

\item{delayedInformation}{Delay of information for delayed response designs. Can be a numeric value or a
numeric vector of length \code{kMax - 1}}

\item{tolerance}{The numerical tolerance, default is \code{1e-08}.}
}
\value{
Returns a \code{\link{TrialDesign}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
  \item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
  \item \code{\link[=print.FieldSet]{print()}} to print the object,
  \item \code{\link[=summary.ParameterSet]{summary()}} to display a summary of the object,
  \item \code{\link[=plot.TrialDesign]{plot()}} to plot the object,
  \item \code{\link[=as.data.frame.TrialDesign]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
  \item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Provides adjusted boundaries and defines a group sequential design.
}
\details{
Depending on \code{typeOfDesign} some parameters are specified, others not. 
For example, only if \code{typeOfDesign} \code{"asHSD"} is selected, \code{gammaA} needs to be specified.

If an alpha spending approach was specified (\code{"asOF"}, \code{"asP"}, \code{"asKD"}, \code{"asHSD"}, or \code{"asUser"}) 
additionally a beta spending function can be specified to produce futility bounds.

For optimum designs, \code{"ASNH1"} minimizes the expected sample size under H1, 
\code{"ASNIFH1"} minimizes the sum of the maximum sample and the expected sample size under H1, 
and \code{"ASNsum"}  minimizes the sum of the maximum sample size, the expected sample size under a value midway H0 and H1, 
and the expected sample size under H1.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of 
the \code{rpact} specific implementation of the generic. 
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and 
to identify the object specific name of it, e.g., 
use \code{methods("plot")} to get all the methods for the \code{plot} generic. 
There you can find, e.g., \code{plot.AnalysisResults} and 
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
# Calculate two-sided critical values for a four-stage 
# Wang & Tsiatis design with Delta = 0.25 at level alpha = 0.05
getDesignGroupSequential(kMax = 4, alpha = 0.05, sided = 2, 
    typeOfDesign = "WT", deltaWT = 0.25) 

\donttest{
# Calculate one-sided critical values and binding futility bounds for a three-stage 
# design with alpha- and beta-spending functions according to Kim & DeMets with gamma = 2.5
# (planned informationRates as specified, default alpha = 0.025 and beta = 0.2)
getDesignGroupSequential(kMax = 3, informationRates = c(0.3, 0.75, 1), 
    typeOfDesign = "asKD", gammaA = 2.5, typeBetaSpending = "bsKD", 
    gammaB = 2.5, bindingFutility = TRUE)
} 

# Calculate the Pocock type alpha spending critical values if the first 
# interim analysis was performed after 40\% of the maximum information was observed
# and the second after 70\% of the maximum information was observed (default alpha = 0.025)
getDesignGroupSequential(informationRates = c(0.4, 0.7), typeOfDesign = "asP") 

}
\seealso{
\code{\link[=getDesignSet]{getDesignSet()}} for creating a set of designs to compare different designs.

Other design functions: 
\code{\link{getDesignCharacteristics}()},
\code{\link{getDesignConditionalDunnett}()},
\code{\link{getDesignFisher}()},
\code{\link{getDesignInverseNormal}()},
\code{\link{getGroupSequentialProbabilities}()},
\code{\link{getPowerAndAverageSampleNumber}()}
}
\concept{design functions}
