% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\name{create_index}
\alias{add_column}
\alias{add_foreign_key}
\alias{add_primary_key}
\alias{create_index}
\alias{create_schema}
\alias{createdb}
\alias{dropdb}
\alias{sql}
\title{Create an index}
\usage{
create_index(tablename, columnname, schemaname = NULL, indexname = NULL,
  unique = FALSE, using = NULL, collate = NULL, descending = FALSE,
  tablespace = NULL, where = NULL)

add_primary_key(tablename, columnname, schemaname = NULL)

add_foreign_key(tablename, columnname, foreign_table, foreign_column = NULL,
  schemaname = NULL, foreign_schema = schemaname)

create_schema(schemaname)

add_column(columnname, columntype, tablename, schemaname = NULL)

createdb(name)

dropdb(name, if_exists = TRUE)
}
\arguments{
\item{tablename}{the name of the table}

\item{columnname}{the name of the column}

\item{schemaname}{specifically in this schema}

\item{indexname}{optional index name to use}

\item{unique}{if true, create a unique index}

\item{using}{the index method}

\item{collate}{set collation}

\item{descending}{if true, sort descending}

\item{tablespace}{create in this tablespace}

\item{where}{restrict to rows matching predicate}

\item{foreign_table}{the foreign table name}

\item{foreign_column}{a key column (defaults to primary key)}

\item{foreign_schema}{the schema of the foreign table}

\item{columntype}{the column SQL type}

\item{name}{name of the database}

\item{if_exists}{don't fail on missing database}
}
\description{
Create and index on an existing table column
}
\details{
Build an index on a column.
}
\author{
Timothy H. Keitt
}

