% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpg.R
\name{stow}
\alias{delete_stowed}
\alias{list_stowed}
\alias{retrieve}
\alias{retrieve_image}
\alias{stow}
\alias{stow_image}
\title{Object storage}
\usage{
stow(..., tablename = "rpgstow", schemaname = "rpgstow")

list_stowed(tablename = "rpgstow", schemaname = "rpgstow")

retrieve(objnames, tablename = "rpgstow", schemaname = "rpgstow")

delete_stowed(objnames, tablename = "rpgstow", schemaname = "rpgstow")

stow_image(imagename = "rpgimage", schemaname = "rpgstow")

retrieve_image(imagename = "rpgimage", schemaname = "rpgstow")
}
\arguments{
\item{...}{a list of objects or object names}

\item{tablename}{the table for storing objects}

\item{schemaname}{the schema to use}

\item{objnames}{a character vector with object names or regular expressions}

\item{imagename}{a table name for stowing the session image}
}
\description{
Serialize and write R objects
}
\details{
These functions allow one to write out any R object to a PostgreSQL
database and later retrieve them into any R session. The pair \code{stow} and
\code{retrieve} are modeled roughly as \code{\link{save}} and \code{\link{load}}.

The contents of \code{...} are handled specially. If a named argument is passed,
then the object will be stowed and retrieved with that name. A raw string will
not be stowed if it matches the name of any R object; the matching R object will
be stowed instead. A vector of strings will however be stowed as is. Object names
will be coerced to valid identifiers using \code{\link{make.names}}. Names must
be unique and not collide with any existing object name in the same table.

\code{retrieve} assigns the stowed values to the
stowed names in the global environment. It will overwrite any variable that
has the same name as a stowed object.

The functions \code{retrieve} and \code{delete_stowed} use regular
expression matching as implemented by the
\href{http://www.postgresql.org/docs/9.1/static/functions-matching.html}{PostgreSQL \code{~} operator}.

\code{stow_image} and \code{retrieve_image} will stow all objects in
the current session and retrieve them later. Note that \code{stow_image} will
overwrite all existing objects stowed within \code{imagename}.
}
\examples{
\dontrun{
createdb("rpgtesting")
connect("rpgtesting")
begin()

stow("test")
list_stowed()
stow("test")
list_stowed()
stow(x = "test")
list_stowed()
x = 1
stow(x)
list_stowed()
stow(y = x)
list_stowed()
rm(x)
retrieve(".*")
print(test)
print(x)
print(y)
delete_stowed(".*")
data(mtcars)
stow(mtcars)
list_stowed()
rm(mtcars)
retrieve("mtcars")
head(mtcars)

rollback()
disconnect()
dropdb("rpgtesting")}

}
\author{
Timothy H. Keitt
}
\seealso{
\code{\link{RApiSerialize}}
}

