% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbSchema.R
\name{dbSchema}
\alias{dbSchema}
\title{Check and create schema.}
\usage{
dbSchema(conn, name, display = TRUE, exec = TRUE)
}
\arguments{
\item{conn}{A connection object (required, even if \code{exec =
FALSE}).}

\item{name}{A character string specifying a PostgreSQL schema
name.}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}). Note: if \code{exec = FALSE}, the function still
checks the existence of the schema, but does not create it if
it does not exists.}
}
\value{
\code{TRUE} if the schema exists (whether it was already
    available or was just created).
}
\description{
Checks the existence, and if necessary, creates a schema.
}
\examples{
\dontrun{
    dbSchema(name = "schema", exec = FALSE)
}
}
\author{
Mathieu Basille \email{basille@ufl.edu}
}
\seealso{
The PostgreSQL documentation:
    \url{http://www.postgresql.org/docs/current/static/sql-createschema.html}
}

