% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_db_wrapper_fns.R
\name{dbIndex}
\alias{dbIndex}
\title{Create an index.}
\usage{
dbIndex(conn, name, colname, idxname, unique = FALSE, method = c("btree",
  "hash", "rtree", "gist"), display = TRUE, exec = TRUE)
}
\arguments{
\item{conn}{A connection object.}

\item{name}{A character string specifying a PostgreSQL table name.}

\item{colname}{A character string specifying the name of the
column to which the key will be associated.}

\item{idxname}{A character string specifying the name of the index
to be created. By default, this is the name of the table
(without the schema) suffixed by \code{_idx}.}

\item{unique}{Logical. Causes the system to check for duplicate
values in the table when the index is created (if data already
exist) and each time data is added. Attempts to insert or
update data which would result in duplicate entries will
generate an error.}

\item{method}{The name of the method to be used for the
index. Choices are \code{"btree"}, \code{"hash"},
\code{"rtree"}, and \code{"gist"}. The default method is
\code{"btree"}, although \code{"gist"} should be the index of
choice for Post GIS spatial types (geometry, geography,
raster).}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}).}
}
\value{
\code{TRUE} if the index was successfully created.
}
\description{
Defines a new index on a PostgreSQL table.
}
\examples{
## examples use a dummy connection from DBI package
conn<-DBI::ANSI()
dbIndex(conn,name = c("schema", "table"), colname = "geom", method = "gist",
    exec = FALSE)
}
\seealso{
The PostgreSQL documentation:
    \url{http://www.postgresql.org/docs/current/static/sql-createindex.html};
    the PostGIS documentation for GiST indexes:
    \url{http://postgis.net/docs/using_postgis_dbmanagement.html#id541286}
}
\author{
Mathieu Basille \email{basille@ufl.edu}
}
