% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgGetBoundary.R
\name{pgGetBoundary}
\alias{pgGetBoundary}
\title{Retrieve bounding envelope of geometries or rasters.}
\usage{
pgGetBoundary(conn, name, geom = "geom", clauses = NULL)
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database}

\item{name}{A character string specifying a PostgreSQL schema and
table/view name holding the geometry (e.g., \code{name =
c("schema","table")})}

\item{geom}{character, Name of the column in \code{name} holding the
geometry/(geography) or raster object (Default = \code{"geom"})}

\item{clauses}{character, additional SQL to append to modify select
query from table. Must begin with an SQL clause (e.g., "WHERE ...",
"ORDER BY ...", "LIMIT ..."); same usage as in \code{pgGetGeom}.}
}
\value{
SpatialPolygon
}
\description{
Retrieve bounding envelope (rectangle) of all geometries or
rasters in a PostGIS table.
}
\examples{
\dontrun{
pgGetBoundary(conn, c("schema", "polys"), geom = "polygon")
pgGetBoundary(conn, c("schema", "rasters"), geom = "rast")
}
}
\author{
David Bucklin \email{david.bucklin@gmail.com}
}
