% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpsftm.R
\name{rpsftm}
\alias{rpsftm}
\title{Rank Preserving Structural Failure Time Model}
\usage{
rpsftm(formula, data, censor_time, subset, na.action, test = survdiff,
  low_psi = -1, hi_psi = 1, alpha = 0.05, treat_modifier = 1,
  autoswitch = TRUE, n_eval_z = 100, ...)
}
\arguments{
\item{formula}{a formula with a minimal structure of \code{Surv(time, status)~rand(arm,rx)}.
Further terms can be added to the right hand side to adjust for covariates and use strata or cluster arguments.}

\item{data}{an optional data frame that contains variables}

\item{censor_time}{the time at which censoring would, or has occurred. This is provided for all observations
unlike standard Kaplan-Meier or Cox regression where it is only given for censored observations. 
If no value is given then recensoring is not applied.}

\item{subset}{expression indicating which subset of the rows of data should be used in the fit. 
This can be a logical vector (which is replicated to have length equal to the number of observations),
a numeric vector indicating which observation numbers are to be included (or excluded if negative), 
or a character vector of row names to be included. All observations are included by default.}

\item{na.action}{a missing-data filter function. This is applied to the model.frame after any subset 
argument has been used. Default is options()$na.action.}

\item{test}{the survival regression function to calculate the z-statistic: survdiff, coxph, survreg}

\item{low_psi}{the lower limit of the range to search for the causal parameter}

\item{hi_psi}{the upper limit of the range to search for the causal paramater}

\item{alpha}{the significance level used to calculate confidence intervals}

\item{treat_modifier}{an optional parameter that psi is multiplied by on an individual observation level to give
differing impact to treatment.}

\item{autoswitch}{a logical to autodetect cases of no switching. If TRUE, then if all observations in an arm
have perfect compliance then recensoring is not applied in that arm. If FALSE the recensoring is applied
regardless of perfect compliance.}

\item{n_eval_z}{The number of points between hi_psi and low_psi at which to evaluate the Z-statistics
in the estimating equation. Default  is 100.}

\item{...}{arguments to supply to the test function.}
}
\value{
a rpsftm method object that is a list of the following:
\itemize{
\item psi: the estimated parameter
\item fit: a survdiff object to produce Kaplan-Meier curves of the estimated counterfactual untreated failure times for each treatment arm
\item formula: a formula representing any adjustments, strata or clusters- used for the \code{update()} function
\item regression: the survival regression object at the estimated value of psi
\item Sstar: the recensored \code{Surv()} data using the estimate value of psi to give counterfactual untreated failure times.
\item ans: the object returned from \code{uniroot} used to solve the estimating equation
\item CI: a vector of the confidence interval around psi
\item call: the R call object
\item eval_z: a data frame with the Z-statistics from the estimating equation evaluated at
a sequence of values of psi. Used to plot and check if the range of values to search for solution
and limits of confidence intervals need to be modified.
}
}
\description{
Main Function used for estmating causal parameters under the Rank Preserving Structural Failure Time Model
}
\details{
the formula object \code{Surv(time, status)~rand(arm,rx)}. \code{rand()} stands 
for randomistion, both the randomly assigned and actual observed treatment. 
\itemize{
  \item arm: the randomised treatment arm. a factor with 2 levels, or numeric variable with values 0/1.
 \item rx: the proportion of time on active treatment (arm=1 or the non-reference level of the factor)
}
Further adjustment terms can be added on the right hand side of the formula if desired, included \code{strata()}
or \code{cluster()} terms.
}
\examples{
?immdef
fit <- rpsftm(Surv(progyrs, prog)~rand(imm,1-xoyrs/progyrs),immdef, censyrs)
print(fit)
summary(fit)
plot(fit)

}
\author{
Simon Bond
}

