% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Essay.R
\docType{class}
\name{Essay-class}
\alias{Essay-class}
\alias{Essay}
\title{Class "Essay"}
\description{
Class \code{Essay} is responsible for creating essay type of assessment
task according to QTI 2.1.
}
\section{Slots}{

\describe{
\item{\code{identifier}}{A character representing the unique identifier of the
assessment task. By default, it is generated as 'id_task_dddd', where dddd
represents random digits.}

\item{\code{title}}{A character representing the title of the XML file associated
with the task. By default, it takes the value of the identifier.}

\item{\code{content}}{A list of character content to form the text of the question,
which can include HTML tags. For tasks of the \link{Entry} type, it must also
contain at least one instance of Gap objects, such as \linkS4class{TextGap},
\link{NumericGap}, or \link{InlineChoice}.}

\item{\code{prompt}}{An optional character representing a simple question text,
consisting of one paragraph. This can supplement or replace content in the
task. Default is "".}

\item{\code{points}}{A numeric value, optional, representing the number of points for
the entire task. Default is 1, but pay attention:
\itemize{
\item For tasks of the \link{Entry} type, it is
calculated as the sum of the gap points by default.
\item For tasks of the \link{MatchTable} type, it can also be calculated as the sum
of points for individual answers, when provided.
\item For tasks of the \link{MultipleChoice} type, points is numeric vector and
required. Each number in this vector determines the number of points that
will be awarded to a candidate if they select the corresponding answer. The
order of the scores must match the order of the \code{choices}. It is possible
to assign negative values to incorrect answers. All answers with a
positive score are considered correct.
}}

\item{\code{feedback}}{A list containing feedback messages for candidates. Each
element of the list should be an instance of either \link{ModalFeedback},
\link{CorrectFeedback}, or \link{WrongFeedback} class.}

\item{\code{calculator}}{A character, optional, determining whether to show a
calculator to the candidate. Possible values:
\itemize{
\item "simple-calculator"
\item "scientific-calculator"
}}

\item{\code{files}}{A character vector, optional, containing paths to files that will
be accessible to the candidate during the test/exam.}

\item{\code{qti_version}}{A character representing the QTI (Question and Test
Interoperability) information model version. Default is 'v2p1'.}

\item{\code{expected_length}}{A numeric, optional. Responsible for setting the size
of the text input field in the content delivery engine.}

\item{\code{expected_lines}}{A numeric, optional. Responsible for setting the number
of rows of the text input field in the content delivery engine.}

\item{\code{words_max}}{A numeric, optional. Responsible for setting the maximum
number of words that a candidate can write in the text input field.}

\item{\code{words_min}}{A numeric, optional. Responsible for setting the minimum
number of words that a candidate should write in the text input field.}

\item{\code{data_allow_paste}}{A logical, optional. Determines whether it is possible
for a candidate to copy text into the text input field. Default is \code{FALSE}.}
}}

\note{
If 'ModalFeedback' is given, default values for slots related to the
text input field are calculated automatically.
}
\examples{
es <- new("Essay",
          identifier = "id_task_1234",
          title = "Essay Task",
          content = list("<p>Develop some idea and write it down in
                                  the text field</p>"),
          prompt = "Write your answer in text field",
          points = 1,
          feedback = list(),
          calculator = "scientific-calculator",
          files = "text_book.pdf",
          expected_length = 100,
          expected_lines = 5,
          words_max = 200,
          words_min = 10,
          data_allow_paste = FALSE)
}
