% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_rows.R
\name{select_rows_se}
\alias{select_rows_se}
\title{Make a select rows node.}
\usage{
select_rows_se(source, expr, env = parent.frame())
}
\arguments{
\item{source}{source to select from.}

\item{expr}{expression to select rows.}

\item{env}{environment to look for values in.}
}
\value{
select columns node.
}
\description{
Make a select rows node.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d <- dbi_copy_to(my_db, 'd',
                data.frame(AUC = 0.6, R2 = 0.2))
eqn <- select_rows_se(d, "AUC >= 0.5")
cat(format(eqn))
sql <- to_sql(eqn, my_db)
cat(sql)
DBI::dbGetQuery(my_db, sql)
DBI::dbDisconnect(my_db)

}
