% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/work_with_NULLs.R
\name{mark_null_cols}
\alias{mark_null_cols}
\title{Indicate NULLs per row for given column set.}
\usage{
mark_null_cols(source, cols)
}
\arguments{
\item{source}{incoming rel_op tree or data.frame.}

\item{cols}{named character, values are columns to track, names are where to land indicators.}
}
\value{
rel_op node or data.frame (depending on input).
}
\description{
Build a query that creates NULL indicators for nulls in slected columns.
}
\examples{

 my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
 winvector_temp_db_handle <- list(
   db = DBI::dbConnect(RSQLite::SQLite(), ":memory:")
 )
 RSQLite::initExtension(winvector_temp_db_handle$db)

 d <- dbi_copy_to(my_db, 'd',
                  data.frame(AUC = c(0.6, 0.5, NA),
                             R2 = c(1.0, 0.9, NA)))
 op_tree <- d \%.>\% mark_null_cols(., qc(AUC_NULL, R2_NULL) :=
                                     qc(AUC, R2))
 cat(format(op_tree))
 sql <- to_sql(op_tree, my_db)
 cat(sql)
 DBI::dbGetQuery(my_db, sql)

 # ad-hoc mode
 data.frame(AUC=c(1,NA,0.5), R2=c(NA,1,0)) \%.>\% op_tree

 # cleanup
 rm(list = "winvector_temp_db_handle")
 DBI::dbDisconnect(my_db)

}
\seealso{
\code{\link{count_null_cols}}, \code{\link{replace_null_cols}}
}
