% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_sql_node.R
\name{non_sql_node}
\alias{non_sql_node}
\title{Wrap a non-SQL node.}
\usage{
non_sql_node(source, ..., f_db = NULL, f_df = NULL, f_dt = NULL,
  incoming_table_name, outgoing_table_name, columns_produced,
  display_form = "non_sql_node", orig_columns = TRUE,
  temporary = TRUE, check_result_details = TRUE,
  env = parent.frame())
}
\arguments{
\item{source}{source to work from (data.frame or relop node)}

\item{...}{force later arguments to bind by name}

\item{f_db}{database implementation signature: f_db(db, incoming_table_name, outgoing_table_name, nd) (db being a database handle)}

\item{f_df}{data.frame implementation signature: f_df(data.frame, nd) (NULL defaults to taking from database).}

\item{f_dt}{data.table implementation signature: f_dt(data.table, nd) (NULL defaults f_df).}

\item{incoming_table_name}{character, name of incoming table}

\item{outgoing_table_name}{character, name of produced table}

\item{columns_produced}{character, names of additional columns produced}

\item{display_form}{character, how to print node}

\item{orig_columns}{logical if TRUE select all original columns.}

\item{temporary}{logical, if TRUE mark tables temporary.}

\item{check_result_details}{logical, if TRUE enforce result type and columns.}

\item{env}{environment to look to.}
}
\value{
non-sql node.
}
\description{
Note: non-SQL nodes are allowed to delete/overwrite both
both the incoming and outgoing tables, so do not point them
to non-temporary structures.  Also they tend to land all columns
(losing narrowing optimization),
so can be expensive and should be used sparingly.  Finally their
result can only be used once in a pipeline (else they will try to clobber their own result).
}
\seealso{
\code{\link{rsummary_node}}, \code{\link{quantile_node}}
}
