% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine_transform.R
\name{affine_transform}
\alias{affine_transform}
\title{Implement an affine transformaton}
\usage{
affine_transform(source, linear_transform, offset, ...,
  env = parent.frame())
}
\arguments{
\item{source}{relop source (or data.frame source)}

\item{linear_transform}{matrix with row names taken from source column names (inputs), and column names are outputs.}

\item{offset}{vector of offsets with names same as column names of linear_transform.}

\item{...}{force later arguments to bind by name}

\item{env}{environment to look for values in.}
}
\value{
relop node
}
\description{
Implement an affine transformaton
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) &&
    requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- data.frame(AUC = 0.6, R2 = 0.2)
  source <- rq_copy_to(my_db, 'd',
                       d,
                       overwrite = TRUE,
                       temporary = TRUE)
  linear_transform <- matrix(c(1 ,1, 2, -1, 1, 0, 0, 0), nrow = 2)
  rownames(linear_transform) <- c("AUC", "R2")
  colnames(linear_transform) <- c("res1", "res2", "res3", "res4")
  offset <- c(5, 7, 1, 0)
  names(offset) <- colnames(linear_transform)

  optree <- affine_transform(source, linear_transform, offset)
  cat(format(optree))

  sql <- to_sql(optree, my_db)
  cat(sql)

  print(DBI::dbGetQuery(my_db, sql))
  print(as.matrix(d) \%*\% linear_transform + offset)

  DBI::dbDisconnect(my_db)
}

}
