% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_rows.R
\name{select_rows}
\alias{select_rows}
\alias{select_rows_nse}
\title{Make a select rows node.}
\usage{
select_rows(source, expr, env = parent.frame())

select_rows_nse(source, expr, env = parent.frame())
}
\arguments{
\item{source}{source to select from.}

\item{expr}{expression to select rows.}

\item{env}{environment to look to.}
}
\value{
select rows node.
}
\description{
Supports \code{bquote()} \code{.()}-style name abstraction including \code{.(-)} notation to promote strings to names
(please see here: \url{https://github.com/WinVector/rquery/blob/master/Examples/Substitution/Substitution.md}).
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2, z = 3))
  TARGETCOL = as.name("AUC")
  optree <- select_rows(d, .(TARGETCOL) >= 0.5) \%.>\%
    select_columns(., "R2")
  cat(format(optree))
  sql <- to_sql(optree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
