% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice-assign.R, R/slice.R
\name{rray_slice<-}
\alias{rray_slice<-}
\alias{rray_slice_assign}
\alias{rray_slice}
\title{Get or set a slice of an array}
\usage{
rray_slice(x, i, axis) <- value

rray_slice_assign(x, i, axis, value)

rray_slice(x, i, axis)
}
\arguments{
\item{x}{A vector, matrix, array or rray.}

\item{i}{Indices to extract along a single axis.
\itemize{
\item Integer indices extract specific elements of the \code{axis} dimension.
\item Logical indices must be length 1, or the length of the \code{axis} dimension.
\item Character indices are only allowed if \code{x} has names for the \code{axis} dimension.
\item \code{NULL} is treated as \code{0}.
}}

\item{axis}{An integer. The axis to subset along.}

\item{value}{A value to be assigned to the location at
\code{rray_slice(x, i, axis)}. It will be cast to the type and dimension
of the slice of \code{x}.}
}
\value{
\code{x} with the \code{i} elements extracted from the \code{axis}.
}
\description{
\code{rray_slice()} is a shortcut wrapper around \code{\link[=rray_subset]{rray_subset()}} that is useful
for easily subsetting along a single axis.
}
\details{
\code{rray_slice()} does exactly the same thing as \code{\link[=rray_subset]{rray_subset()}}, and is
mainly helpful for higher dimensional objects, when you need to subset
along, for example, only the 4th dimension.
}
\examples{
x <- rray(1:16, c(2, 2, 2, 2))

# Selecting the first column
rray_slice(x, i = 1, axis = 2)

# rray_slice() is particularly useful for
# subsetting higher dimensions because you don't
# have to worry about the commas
rray_slice(x, i = 2, axis = 4)

# Compare the above with the equivalent using `[`
x[, , , 2]

# `i` can be a character vector if `x` has names along `axis`
x <- rray_set_axis_names(x, axis = 4, c("foo", "bar"))
rray_slice(x, "bar", axis = 4)

# The assignment variation can be useful
# for assigning to higher dimensional elements
rray_slice(x, 1, 3) <- matrix(c(99, 100), nrow = 1)

}
\seealso{
Other rray subsetters: \code{\link{rray_extract<-}},
  \code{\link{rray_subset<-}}, \code{\link{rray_yank<-}}
}
\concept{rray subsetters}
