% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset-assign.R, R/subset.R
\name{rray_subset<-}
\alias{rray_subset<-}
\alias{[<-.vctrs_rray}
\alias{rray_subset_assign}
\alias{rray_subset}
\alias{[.vctrs_rray}
\title{Get or set dimensions of an array}
\usage{
rray_subset(x, ...) <- value

\method{[}{vctrs_rray}(x, ...) <- value

rray_subset_assign(x, ..., value)

rray_subset(x, ...)

\method{[}{vctrs_rray}(x, ..., drop = FALSE)
}
\arguments{
\item{x}{A vector, matrix, array, or rray.}

\item{...}{A specification of indices to extract.
\itemize{
\item Integer-ish indices extract specific elements of dimensions.
\item Logical indices must be length 1, or the length of the dimension you are
subsetting over.
\item Character indices are only allowed if \code{x} has names for the corresponding
dimension.
\item \code{NULL} is treated as \code{0}.
}}

\item{value}{The value to assign to the location specified by \code{...}. Before
assignment, \code{value} is cast to the type and dimension of \code{x[...]}.}

\item{drop}{Ignored, but preserved for better error messages with code
that might have used arrays before.}
}
\value{
\code{x} subset by the specification defined in the \code{...}.

The assignment variants return \code{x} modified by having the elements of
\code{value} inserted into the positions defined by \code{...}.
}
\description{
\code{rray_subset()} extracts dimensions from an array \emph{by index}. It powers \code{[}
for rray objects. Notably, it \emph{never} drops dimensions, and ignores
trailing commas.
}
\details{
\code{rray_subset()} and its assignment variant can also be used with base R
matrices and arrays to get rray subsetting behavior with them.
}
\section{Differences from base R}{

\itemize{
\item \code{rray_subset()} \emph{never} drops dimensions.
\item \code{rray_subset()} ignores trailing commas. This has the nice property of
making \code{x[1] == x[1,]}.
\item \code{rray_subset()<-} casts \code{value} to \code{x}, rather than
casting \code{x} to \code{value}.
}
}

\examples{
x <- rray(1:8, c(2, 2, 2))

# `rray_subset()` powers `[` so these are identical
rray_subset(x, 1)
x[1]

# Trailing dots are ignored, so these are identical
x[1]
x[1,]

# Missing arguments are treated as selecting the
# entire dimension, consistent with base R.
# This selects all of the rows, and the first column.
x[,1]

# Notice that you can't actually do the above with base
# R. It requires you to fully specify the dimensions of `x`.
# This would throw an error.
x_arr <- as_array(x)
try(x_arr[,1])

# To get the same behavior, you have to do:
x_arr[, 1, , drop = FALSE]

# Note that you can use base R arrays with `rray_subset()`
rray_subset(x_arr, , 1)

# For higher dimensional objects, `pad()` can be
# useful for automatically adding commas. The
# following are equivalent:
x[pad(), 1]
x[, , 1]

# You can assign to index locations with
# `x[...] <- value`
# This assigns 99 to the entire first row
x[1] <- 99
x

# First row in the first
# element of the 3rd dimension
x[1, , 1] <- 100
x

# Note that `value` is broadcast to the shape
# of `x[...]`. So this...
x[,1] <- matrix(5)

# ...becomes the same as
x[,1] <- array(5, c(2, 1, 2))

# You can also use `rray_subset<-()` directly to
# use these semantics with base R
rray_subset(x_arr, , 1) <- matrix(5)
x_arr

}
\seealso{
\code{\link[=pad]{pad()}}

Other rray subsetters: \code{\link{rray_extract<-}},
  \code{\link{rray_slice<-}}, \code{\link{rray_yank<-}}
}
\concept{rray subsetters}
