\name{hbk}
\alias{hbk}
\alias{hbk.x}
\alias{hbk.y}
\docType{data}
\title{ Hawkins, Bradu, Kass's Artificial Data }
\description{

Artifical Data Set generated by Hawkins, Bradu, and Kass (1984). The data set consists of 75 observations in four dimensions (one response and three explanatory variables). The first 14 observations are outliers, created in two groups: 1-10 and 11-14. Only observations 12, 13 and 14 appear as outliers when using classical methods.
}
\usage{data(hbk)}
\format{
  A data frame with 75 observations on 4 variables, where the last variable is the dependent one.
  \describe{
    \item{X1}{x[1]}
    \item{X2}{x[2]}
    \item{X3}{x[3]}
    \item{Y}{y}
  }

 For convenience, the data sets \code{hbk.x}, a matrix with the three (independent) variables of the data frame, and \code{hbk.y}, the numeric vector giving the fourth (dependent) variable, are provided as well. 

}
\Note{
  This data set is also available in the package \code{wle} as 'artificial'
}
\source{
Hawkins, D.M., Bradu, D., and Kass, G.V. (1984)
  Location of several outliers in multiple regression data using elemental sets.
  \emph{Technometrics,}
  \bold{26}, 197--208.

}

\seealso{
 P. J. Rousseeuw and A. M. Leroy (1987) 
 \emph{Robust Regression and Outlier Detection.} Wiley, p.94. 
}
\examples{
data(hbk)
plot(hbk.x)
covMcd(hbk.x)
summary(lm.hbk <- lm(hbk.y ~ hbk.x))

}
\keyword{datasets}
