/*
 * Decompiled with CFR 0.152.
 */
package com.github.egonw.rrdf;

import com.github.egonw.rrdf.StringMatrix;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class RJenaHelper {
    public static Model newOntoRdf() throws Exception {
        return ModelFactory.createOntologyModel();
    }

    public static Model newRdf() throws Exception {
        return ModelFactory.createDefaultModel();
    }

    public static Model loadRdf(String filename, String format) throws Exception {
        return RJenaHelper.loadRdf(filename, format, (Model)ModelFactory.createOntologyModel());
    }

    public static Model loadRdf(String filename, String format, Model appendTo) throws Exception {
        File file = new File(filename);
        FileInputStream stream = new FileInputStream(file);
        appendTo.read((InputStream)stream, "", format);
        return appendTo;
    }

    public static Model fromString(String rdfContent, String format) throws Exception {
        return RJenaHelper.fromString(rdfContent, format, RJenaHelper.newRdf());
    }

    public static Model fromString(String rdfContent, String format, Model appendTo) throws Exception {
        ByteArrayInputStream stream = new ByteArrayInputStream(rdfContent.getBytes());
        appendTo.read((InputStream)stream, "", format);
        return appendTo;
    }

    public static String toString(Model model, String format) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        model.write((OutputStream)output, format);
        output.close();
        String result = new String(output.toByteArray());
        return result;
    }

    public static void saveRdf(Model model, String filename, String format) throws Exception {
        File file = new File(filename);
        FileOutputStream stream = new FileOutputStream(file);
        model.write((OutputStream)stream, format);
        ((OutputStream)stream).close();
    }

    public static String dump(Model model) {
        StringBuffer dump = new StringBuffer();
        StmtIterator statements = model.listStatements();
        while (statements.hasNext()) {
            Statement statement = statements.nextStatement();
            RDFNode object = statement.getObject();
            dump.append(statement.getSubject().getLocalName()).append(' ').append(statement.getPredicate().getLocalName()).append(' ').append(object instanceof Resource ? object.toString() : String.valueOf('\"') + object.toString() + "\"").append('\n');
        }
        return dump.toString();
    }

    public static int tripleCount(Model model) {
        return (int)model.size();
    }

    public static StringMatrix sparql(Model model, String queryString) throws Exception {
        StringMatrix table = null;
        Query query = QueryFactory.create((String)queryString);
        PrefixMapping prefixMap = query.getPrefixMapping();
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        try {
            ResultSet results = qexec.execSelect();
            table = RJenaHelper.convertIntoTable(prefixMap, results);
        }
        finally {
            qexec.close();
        }
        return table;
    }

    public static StringMatrix sparqlRemote(String endpoint, String queryString) throws Exception {
        return RJenaHelper.sparqlRemote(endpoint, queryString, null, null);
    }

    public static StringMatrix sparqlRemoteNoJena(String endpoint, String queryString) throws Exception {
        return RJenaHelper.sparqlRemoteNoJena(endpoint, queryString, null, null);
    }

    public static StringMatrix sparqlRemoteNoJena(String endpoint, String queryString, String user, String password) throws Exception {
        StringMatrix table = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        if (user != null) {
            URL endpointURL = new URL(endpoint);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(endpointURL.getHost(), -1), (Credentials)new UsernamePasswordCredentials(user, password));
            httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("query", queryString));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, "UTF-8");
        HttpPost httppost = new HttpPost(endpoint);
        httppost.setEntity((HttpEntity)entity);
        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        HttpEntity responseEntity = response.getEntity();
        InputStream in = responseEntity.getContent();
        ResultSet results = ResultSetFactory.fromXML((InputStream)in);
        Query query = QueryFactory.create((String)queryString);
        PrefixMapping prefixMap = query.getPrefixMapping();
        table = RJenaHelper.convertIntoTable(prefixMap, results);
        in.close();
        return table;
    }

    public static StringMatrix sparqlRemote(String endpoint, String queryString, String user, String password) throws Exception {
        StringMatrix table = null;
        Query query = QueryFactory.create((String)queryString);
        QueryEngineHTTP qexec = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)endpoint, (Query)query);
        if (user != null) {
            qexec.setBasicAuthentication(user, password.toCharArray());
        }
        PrefixMapping prefixMap = query.getPrefixMapping();
        try {
            ResultSet results = qexec.execSelect();
            table = RJenaHelper.convertIntoTable(prefixMap, results);
        }
        finally {
            qexec.close();
        }
        return table;
    }

    public static Model construct(Model model, String queryString) throws Exception {
        Model result = null;
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        try {
            result = qexec.execConstruct();
        }
        finally {
            qexec.close();
        }
        return result;
    }

    public static Model constructRemote(String endpoint, String queryString) throws Exception {
        Model result = null;
        Query query = QueryFactory.create((String)queryString);
        QueryEngineHTTP qexec = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)endpoint, (Query)query);
        try {
            result = qexec.execConstruct();
        }
        finally {
            qexec.close();
        }
        return result;
    }

    private static StringMatrix convertIntoTable(PrefixMapping prefixMap, ResultSet results) {
        StringMatrix table = new StringMatrix();
        int rowCount = 0;
        List resultVarNames = results.getResultVars();
        while (results.hasNext()) {
            ++rowCount;
            QuerySolution soln = results.nextSolution();
            for (String varName : resultVarNames) {
                int colCount = -1;
                if (table.hasColumn(varName)) {
                    colCount = table.getColumnNumber(varName);
                } else {
                    colCount = table.getColumnCount() + 1;
                    table.setColumnName(colCount, varName);
                }
                RDFNode node = soln.get(varName);
                if (node == null) continue;
                if (node.isResource()) {
                    Resource resource = (Resource)node;
                    if (resource.isAnon()) {
                        table.set(rowCount, colCount, "" + resource.getId());
                        continue;
                    }
                    String[] uriLocalSplit = RJenaHelper.split(prefixMap, resource);
                    if (uriLocalSplit[0] == null) {
                        if (resource.getURI() != null) {
                            table.set(rowCount, colCount, resource.getURI());
                            continue;
                        }
                        table.set(rowCount, colCount, "" + resource.hashCode());
                        continue;
                    }
                    table.set(rowCount, colCount, String.valueOf(uriLocalSplit[0]) + ":" + uriLocalSplit[1]);
                    continue;
                }
                if (node.isLiteral()) {
                    Literal literal = (Literal)node;
                    table.set(rowCount, colCount, literal.getString());
                    continue;
                }
                String nodeStr = node.toString();
                if (nodeStr.endsWith("@en")) {
                    nodeStr = nodeStr.substring(0, nodeStr.lastIndexOf(64));
                }
                table.set(rowCount, colCount, nodeStr);
            }
        }
        return table;
    }

    public static String[] split(PrefixMapping prefixMap, Resource resource) {
        String uri = resource.getURI();
        if (uri == null) {
            return new String[2];
        }
        Map prefixMapMap = prefixMap.getNsPrefixMap();
        Set prefixes = prefixMapMap.keySet();
        String[] split = new String[2];
        for (String key : prefixes) {
            String ns = (String)prefixMapMap.get(key);
            if (!uri.startsWith(ns)) continue;
            split[0] = key;
            split[1] = uri.substring(ns.length());
            return split;
        }
        split[1] = uri;
        return split;
    }

    public static void addObjectProperty(Model model, String subject, String property, String object) throws Exception {
        Resource subjectRes = model.createResource(subject);
        Property propertyRes = model.createProperty(property);
        Resource objectRes = model.createResource(object);
        model.add(subjectRes, propertyRes, (RDFNode)objectRes);
    }

    public static void addDataProperty(Model model, String subject, String property, String value) throws Exception {
        RJenaHelper.addDataProperty(model, subject, property, value, null);
    }

    public static void addDataProperty(Model model, String subject, String property, String value, String dataType) throws Exception {
        Resource subjectRes = model.createResource(subject);
        Property propertyRes = model.createProperty(property);
        if (dataType == null) {
            model.add(subjectRes, propertyRes, value);
        } else {
            model.add(subjectRes, propertyRes, value, (RDFDatatype)new XSDDatatype(dataType));
        }
    }

    public static void addPrefix(Model model, String prefix, String namespace) {
        model.setNsPrefix(prefix, namespace);
    }
}

