/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.DAML_OILProfile;
import com.hp.hpl.jena.ontology.impl.OWLDLProfile;
import com.hp.hpl.jena.ontology.impl.OWLLiteProfile;
import com.hp.hpl.jena.ontology.impl.OWLProfile;
import com.hp.hpl.jena.ontology.impl.RDFSProfile;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashMap;
import java.util.Map;

public class ProfileRegistry {
    public static final String OWL_LANG = OWL.FULL_LANG.getURI();
    public static final String OWL_DL_LANG = OWL.DL_LANG.getURI();
    public static final String OWL_LITE_LANG = OWL.LITE_LANG.getURI();
    public static final String DAML_LANG = "http://www.daml.org/2001/03/daml+oil#";
    public static final String RDFS_LANG = RDFS.getURI();
    private static Object[][] s_initData = new Object[][]{{OWL_LANG, new OWLProfile()}, {OWL_DL_LANG, new OWLDLProfile()}, {OWL_LITE_LANG, new OWLLiteProfile()}, {"http://www.daml.org/2001/03/daml+oil#", new DAML_OILProfile()}, {RDFS_LANG, new RDFSProfile()}};
    private static ProfileRegistry s_instance = new ProfileRegistry();
    private Map<String, Profile> m_registry = new HashMap<String, Profile>();

    private ProfileRegistry() {
        for (int i = 0; i < s_initData.length; ++i) {
            this.registerProfile((String)s_initData[i][0], (Profile)s_initData[i][1]);
        }
    }

    public static ProfileRegistry getInstance() {
        return s_instance;
    }

    public void registerProfile(String uri, Profile profile) {
        this.m_registry.put(uri, profile);
    }

    public Profile getProfile(String uri) {
        return this.m_registry.get(uri);
    }
}

