% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{refine_id}
\alias{refine_id}
\title{Helper function to get OpenRefine project.id by project.name}
\usage{
refine_id(project.name, project.id, ...)
}
\arguments{
\item{project.name}{Name of project}

\item{project.id}{Unique identifier for project}

\item{...}{Additional parameters to be inherited by \code{\link{refine_path}}; allows users to specify \code{host} and \code{port} arguments if the OpenRefine instance is running at a location other than \verb{http://127.0.0.1:3333}}
}
\value{
Unique id of project
}
\description{
For functions that allow either a project name or id to be passed, this function is used internally to resolve the project id from name if necessary. It also validates that values passed to the `project.id`` argument match an existing project id in the running OpenRefine instance.
}
