% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix2dataframe.R
\name{matrix2dataframe}
\alias{matrix2dataframe}
\title{matrix2dataframe}
\usage{
matrix2dataframe(m, decreasing = TRUE, tol = 1e-09)
}
\arguments{
\item{m}{numeric: a matrix of values}

\item{decreasing}{logical: should the sort order be increasing or decreasing (default: \code{TRUE})}

\item{tol}{numeric: tolerance used to detect if matrix is symmetrical (default: \code{1e-9})}
}
\value{
a data frame with an attribute \code{matrix} with \code{m}
}
\description{
Converts a numeric matrix to a data frame with decreasing or increasing values:
First column row index, second column col index and third column the value.
If the matrix is symmetrical, only the upper triangle is taken into account.
}
\examples{
# non-symmetric
x <- matrix(runif(9), ncol=3)
matrix2dataframe(x)
# symmetric
x <- x+t(x)
matrix2dataframe(x)
}
