% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bundleFiles.R
\name{listDeploymentFiles}
\alias{listDeploymentFiles}
\title{Gather files to be bundled with an app}
\usage{
listDeploymentFiles(
  appDir,
  appFiles = NULL,
  appFileManifest = NULL,
  error_call = caller_env()
)
}
\arguments{
\item{appDir}{A directory containing an application (e.g. a Shiny app
or plumber API). Defaults to the current directory.}

\item{appFiles, appFileManifest}{Use \code{appFiles} to specify a
character vector of files to bundle in the app or \code{appManifestFiles}
to provide a path to a file containing a list of such files. If neither
are supplied, will bundle all files in \code{appDir}, apart from standard
exclusions and files listed in a \code{.rscignore} file. See
\code{\link[=listDeploymentFiles]{listDeploymentFiles()}} for more details.}

\item{error_call}{The call or environment for error reporting; expert
use only.}
}
\value{
Character of paths to bundle, relative to \code{appDir}.
}
\description{
Given an app directory, and optional \code{appFiles} and \code{appFileManifest}
arguments, returns vector of paths to bundle in the app. (Note that
documents follow a different strategy; see \code{\link[=deployDoc]{deployDoc()}} for details.)

When neither \code{appFiles} nor \code{appFileManifest} is supplied,
\code{listDeploymentFiles()} will include all files under \code{appDir}, apart
from the following:
\itemize{
\item Certain files and folders that don't need to be bundled, such as
version control directories, internal config files, and RStudio state,
are automatically excluded.
\item You can exclude additional files by listing them in in a \code{.rscignore}
file. This file must have one file or directory per line (with path
relative to the current directory). It doesn't support wildcards, or
ignoring files in subdirectories.
}

\code{listDeploymentFiles()} will throw an error if the total file size exceeds
the maximum bundle size (as controlled by option \code{rsconnect.max.bundle.size}),
or the number of files exceeds the maximum file limit (as controlled by
option \code{rsconnect.max.bundle.files}). This prevents you from accidentally
bundling a very large direcfory (i.e. you home directory).
}
