% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsdNE.R
\name{asym1}
\alias{asym1}
\title{This generates a class of asymmetric rotatable response surface designs with neighbour effects under a second order model}
\usage{
asym1(n1, n2, c)
}
\arguments{
\item{n1}{n1 factors having 2 levels, 1<=n1<=5}

\item{n2}{n2 factors having 3 levels, 1<=n2<=5}

\item{c}{Value of alpha (Coefficient of neighbour effects), 0<=c<=1}
}
\value{
This function generates rotatable designs as well as Z_prime_Z matrix,
inv(Z_primeZ) matrix and variance estimated response for the (2^n1 * 3^n2) factorial combination.
}
\description{
This function generates asymmetrical rotatable response surface designs in the presence of neighbour effects for 2n factors, n factors at 2 levels and another n factors at 3 levels.
}
\note{
Here 3 types of cases have been considered:
(2^n1*3^n2), where, n1=n2=n;
(2^n1*3), where, n1=n and n2=1;
(2*3^n2), where, n1=1 and n2=n.
}
\examples{
library(rsdNE)
asym1(1,1,0.5)
##X matrix
#      [,1] [,2] [,3] [,4]
#[1,]    1   -1   -1    1
#[2,]    1    1    1    1
#[3,]    1    1    0    0
#[4,]    1    1   -1    1
#[5,]    1   -1    1    1
#[6,]    1   -1    0    0
#[7,]    1   -1   -1    1
#[8,]    1    1    1    1
##Z prime Z matrix
#      [,1] [,2] [,3] [,4]
#[1,]   24    0    0   16
#[2,]    0   12    0    0
#[3,]    0    0    1    0
#[4,]   16    0    0   11
##Z prime Z imverse matrix
#      [,1]       [,2]   [,3]  [,4]
#[1,]  1.375 0.00000000    0   -2
#[2,]  0.000 0.08333333    0    0
#[3,]  0.000 0.00000000    1    0
#[4,] -2.000 0.00000000    0    3
#[1] "total number of runs" "6"
#[1] "variance of esitmated response" "1.4583"
}
\references{
Verma et al.2021, Communication in Statistics – Simulation and Computation
}
\author{
Ashutosh Dalal, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Seema Jaggi, Education Division, ICAR, Krishi Anusandhan Bhawan - II, Pusa, New Delhi.
Eldho Varghese,Fishery Resources Assessment Division,ICAR-CMFRI, Kochi.
Subhasish Sarkar, Division of Computer Application,ICAR-IASRI, New Delhi.
Arpan Bhowmik, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Cini Varghese, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Anindita Datta, Division of Design of Experiments,ICAR-IASRI, New Delhi.
Soumen Pal, Division of Computer Application,ICAR-IASRI, New Delhi.
}
