% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SETSe_auto.R
\name{SETSe_auto}
\alias{SETSe_auto}
\title{SETSe embedding with automatic drag and timestep selection}
\usage{
SETSe_auto(
  g,
  force = "force",
  distance = "distance",
  edge_name = "edge_name",
  k = "k",
  tstep = 0.02,
  mass = 1,
  max_iter = 1e+05,
  tol = 0.002,
  sparse = FALSE,
  hyper_iters = 100,
  hyper_tol = 0.01,
  hyper_max = 30000,
  drag_min = 0.01,
  drag_max = 100,
  tstep_change = 0.2,
  sample = 100,
  static_limit = NULL,
  verbose = FALSE,
  include_edges = TRUE,
  noisy_termination = TRUE
)
}
\arguments{
\item{g}{An igraph object}

\item{force}{A character string. This is the node attribute that contains the force the nodes exert on the network.}

\item{distance}{A character string. The edge attribute that contains the original/horizontal distance between nodes.}

\item{edge_name}{A character string. This is the edge attribute that contains the edge_name of the edges.}

\item{k}{A character string. This is k for the moment don't change it.}

\item{tstep}{A numeric. The time interval used to iterate through the network dynamics.}

\item{mass}{A numeric. This is the mass constant of the nodes in normalised networks this is set to 1.}

\item{max_iter}{An integer. The maximum number of iterations before stopping. Larger networks usually need more iterations.}

\item{tol}{A numeric. The tolerance factor for early stopping.}

\item{sparse}{Logical. Whether or not the function should be run using sparse matrices. must match the actual matrix, this could prob be automated}

\item{hyper_iters}{integer. The hyper parameter that determines the number of iterations allowed to find an acceptable convergence value.}

\item{hyper_tol}{numeric. The convergence tolerance when trying to find the minimum value}

\item{hyper_max}{integer. The maximum number of iterations that SETSe will go through whilst searching for the minimum.}

\item{drag_min}{integer. A power of ten. The lowest drag value to be used in the search}

\item{drag_max}{integer. A power of ten. if the drag exceeds this value the tstep is reduced}

\item{tstep_change}{numeric. A value between 0 and 1 that determines how much the time step will be reduced by default value is 0.5}

\item{sample}{Integer. The dynamics will be stored only if the iteration number is a multiple of the sample. 
This can greatly reduce the size of the results file for large numbers of iterations. Must be a multiple of the max_iter}

\item{static_limit}{Numeric. The maximum value the static force can reach before the algorithm terminates early. This
prevents calculation in a diverging system. The value should be set to some multiple greater than one of the force in the system.
If left blank the static limit is the system absolute mean force.}

\item{verbose}{Logical. This value sets whether messages generated during the process are suppressed or not.}

\item{include_edges}{logical. An optional variable on whether to calculate the edge tension and strain. Default is TRUE.
included for ease of integration into the bicomponent functions.}

\item{noisy_termination}{Stop the process if the static force does not monotonically decrease.}
}
\value{
A list of four elements. A data frame with the height embeddings of the network, a data frame of the edge embeddings, 
the convergence dynamics dataframe for the network as well as the search history for convergence criteria of the network
}
\description{
Uses a grid search and a binary search to find appropriate convergence conditions.
}
\details{
This is one of the most commonly used SETSe functions. It automatically selects the convergence time-step and drag values
to ensure efficient convergence.

The noisy_termination parameter is used as in some cases the convergence process can get stuck in the noisy zone of SETSe space.
To prevent this the process is stopped early if the static force does not monotonically decrease.  On large networks this 
greatly speeds up the search for good parameter values. It increases the chance of successful convergence. 
More detail on auto-SETSe can be found in the paper "The spring bounces back" (Bourne 2020).
}
\examples{

set.seed(234) #set the random see for generating the network

g <- generate_peels_network(type = "E")

g_prep <- g \%>\%
#prepare the network for a binary embedding
prepare_SETSe_binary(., node_names = "name", k = 1000, 
                     force_var = "class", 
                     positive_value = "A")
                     
#embed the network using auto SETSe with default settings
embeddings <- SETSe_auto(g_prep)

}
\seealso{
\code{\link{SETSe}} \code{\link{SETSe_bicomp}}
}
