% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SETSe_expanded.R
\name{SETSe_expanded}
\alias{SETSe_expanded}
\title{SETSe embedding showing full convergence history}
\usage{
SETSe_expanded(
  g,
  force = "force",
  distance = "distance",
  edge_name = "edge_name",
  k = "k",
  tstep = 0.02,
  mass = 1,
  max_iter = 20000,
  coef_drag = 1,
  tol = 1e-06,
  sparse = FALSE,
  verbose = TRUE,
  two_node_solution = TRUE
)
}
\arguments{
\item{g}{An igraph object. The network}

\item{force}{A character string}

\item{distance}{A character string. The name of the graph attribute that contains the graph distance}

\item{edge_name}{A character string. This is the edge attribute that contains the edge_name of the edges.}

\item{k}{A character string. This is k for the moment don't change it.}

\item{tstep}{A numeric. The time in seconds that elapses between each iteration}

\item{mass}{A numeric. The mass in kg of the nodes, this is arbitrary and commonly 1 is used.}

\item{max_iter}{An integer. The maximum number of iterations before terminating the simulation}

\item{coef_drag}{A numeric. A multiplier used to tune the damping. Generally no need to twiddle}

\item{tol}{A numeric. Early termination. If the dynamics of the nodes fall below this value the algorithm will be classed as 
"converged" and the simulation terminates.}

\item{sparse}{Logical. Whether or not the function should be run using sparse matrices. must match the actual matrix, this could prob be automated}

\item{verbose}{Logical value. Whether the function should output messages or run quietly.}

\item{two_node_solution}{Logical. The Newton-Raphson algo is used to find the correct angle}
}
\value{
A list of four elements. A dat frame with the height embedding of the network, a data frame of the edge embeddings, 
the convergence dynamics dataframe for the network as well as the search history for convergence criteria of the network
}
\description{
This is a special case function which keeps the history of the network dynamics. It is useful for demonstrations. 
or parametrising difficult networks
}
\examples{

g_prep <- biconnected_network \%>\%
 prepare_SETSe_continuous(., node_names = "name", force_var = "force", k = NULL)

#the base configuration does not work
divergent_result <- SETSe_expanded(g_prep, k = "weight", tstep = 0.1)

#with a smaller timestep the algorithm converges
convergent_result <- SETSe_expanded(g_prep, k = "weight", tstep = 0.01)

\dontrun{
library(ggplot2)
#plot the results for a given node
convergent_result \%>\%
 ggplot(aes(x = t, y = net_force, colour = node)) + geom_line()
#replot with divergent_result to see what it looks like
}
}
