% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\name{find_possible_distribution}
\alias{find_possible_distribution}
\title{Find a possible distribution.}
\usage{
find_possible_distribution(parameters, seed = NULL, values_only = FALSE)
}
\arguments{
\item{parameters}{List of parameters, see \code{\link{set_parameters}}}

\item{seed}{An integer to use as the seed for random number generation. Set this in scripts to ensure reproducibility.}

\item{values_only}{Should only values or a more informative list be returned. See Value section.}
}
\value{
Unless \code{values_only = TRUE}, a list with:
\item{outcome}{success or failure - character}
\item{distribution}{The distribution that was found (if success) / that had the closest variance (if failure) - numeric}
\item{mean}{The exact mean of the distribution - numeric}
\item{sd}{The SD of the distribution that was found (success) / that came closest (failure) - numeric}
\item{iterations}{The number of iterations required to achieve the specified SD - numeric}
If \code{values_only = TRUE}, then the distribution is returned if one was found, and NULL if it failed.
}
\description{
This function aims to find a possible distribution that would give rise to
the observed sample parameters. For that, you need to pass a list of parameters,
best created with \code{\link{set_parameters}}
}
\examples{
sprite_parameters <- set_parameters(mean = 2.2, sd = 1.3, n_obs = 20,
                                    min_val = 1, max_val = 5)
find_possible_distribution(sprite_parameters)

}
