% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{collections}
\alias{collections}
\title{Endpoint functions}
\usage{
collections(q, collection_id = NULL)
}
\arguments{
\item{q}{a \code{RSTACQuery} object expressing a STAC query
criteria.}

\item{collection_id}{a \code{character} collection id to be retrieved.}
}
\value{
A \code{RSTACQuery} object with the subclass \code{collections} for
 \code{/collections/} endpoint, or a \code{collection_id} subclass for
 \code{/collections/{collection_id}} endpoint, containing all search field
 parameters to be provided to STAC API web service.
}
\description{
The \code{collections} function implements the WFS3 \code{/collections}
 and \code{/collections/\{collectionId\}} endpoints.

Each endpoint retrieves specific STAC objects:
\itemize{
  \item \code{/collections}: Returns a list of STAC Collection published in
    the STAC service
  \item \code{/collections/\{collectionId\}}: Returns a single STAC
    Collection object
}
}
\examples{
\donttest{
stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  collections() \%>\%
  get_request()

stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  collections(collection_id = "CB4_64_16D_STK-1") \%>\%
  get_request()
}
}
\seealso{
\code{\link{get_request}}, \code{\link{post_request}},
 \code{\link{items}}
}
