% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{items_group}
\alias{items_group}
\title{Utility functions}
\usage{
items_group(items, ..., field = NULL, index = NULL)
}
\arguments{
\item{items}{a \code{STACItemCollection} object representing
the result of \code{/stac/search}, \code{/collections/{collectionId}/items}.}

\item{...}{a named way to provide field names to get the subfields values
from the \code{RSTACDocument} objects.}

\item{field}{a \code{character} with the names of the field to get the
subfields values from the \code{RSTACDocument} objects.}

\item{index}{a \code{character} with the indexes to be grouped. It can be
used with the function \link{items_reap}.}
}
\value{
a \code{list} in which each index corresponds to a group with its
 corresponding \code{STACItemCollection} objects.
}
\description{
This function groups the items contained within the
 \code{STACItemCollection} object according to some specified fields. Each
 index in the returned list contains items belonging to the same group.
}
\examples{
\donttest{
# STACItemCollection object
stac_item <- stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4_64_16D_STK-1", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
 get_request() \%>\% items_fetch(progress = FALSE)

 stac_item \%>\% items_group(., field = c("properties", "bdc:tiles"))
}

}
