% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-adapt_delta.R
\name{adapt_delta}
\alias{adapt_delta}
\title{Target average acceptance probability}
\description{
Details about the \code{adapt_delta} argument to \pkg{rstap}'s modeling
functions - also found in the \pkg{rstanarm} documentation.
}
\details{
For the No-U-Turn Sampler (NUTS), the variant of Hamiltonian Monte 
  Carlo used used by \pkg{rstap}, \code{adapt_delta} is the target average
  proposal acceptance probability for adaptation. 
  
  The default value of \code{adapt_delta} is 0.95
  
  In general you should not need to change \code{adapt_delta} unless you see
  a warning message about divergent transitions, in which case you can
  increase \code{adapt_delta} from the default to a value \emph{closer} to 1
  (e.g. from 0.95 to 0.99, or from 0.99 to 0.999, etc). The step size used by
  the numerical integrator is a function of \code{adapt_delta} in that
  increasing \code{adapt_delta} will result in a smaller step size and fewer
  divergences. Increasing \code{adapt_delta} will typically result in a
  slower sampler, but it will always lead to a more robust sampler.
}
\references{
Stan Development Team. (2017). \emph{Stan Modeling Language Users Guide and
Reference Manual.} \url{http://mc-stan.org/documentation/}
}
