% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohens_d.R
\name{cohens_d}
\alias{cohens_d}
\title{Compute Cohen's d Measure of Effect Size}
\usage{
cohens_d(data, formula, paired = FALSE, mu = 0, var.equal = FALSE)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
numeric variable giving the data values and \code{group} is a factor with
one or multiple levels giving the corresponding groups. For example,
\code{formula = TP53 ~ cancer_group}.}

\item{paired}{a logical indicating whether you want a paired test.}

\item{mu}{theoretical mean, use for one-sample t-test. Default is O.}

\item{var.equal}{a logical variable indicating whether to treat the two
variances as being equal. If TRUE then the pooled variance is used to
estimate the variance otherwise the Welch (or Satterthwaite) approximation
to the degrees of freedom is used.}
}
\value{
a data frame containing the Cohen's d and the magnitude.
}
\description{
Compute the effect size for t-test. T-test conventional effect
  sizes, poposed by Cohen, are: 0.2 (small efect), 0.5 (moderate effect) and
  0.8 (large effect).
}
\examples{
# One-sample t test effect size
ToothGrowth \%>\% cohens_d(len ~ 1, mu = 0)

# Two indepedent samples t-test effect size
ToothGrowth \%>\% cohens_d(len ~ supp, var.equal = TRUE)

# Paired samples effect size
df <- data.frame(
  id = 1:5,
  pre  = c(110, 122, 101, 120, 140),
  post = c(150, 160, 110, 140, 155)
)
df <- df \%>\% gather(key = "treatment", value = "value", -id)
head(df)

df \%>\% cohens_d(value ~ treatment, paired = TRUE)
}
