% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_rstudio_keyboard_shortcut.R
\name{use_rstudio_keyboard_shortcut}
\alias{use_rstudio_keyboard_shortcut}
\title{Set RStudio Keyboard Shortcuts}
\usage{
use_rstudio_keyboard_shortcut(..., .write_json = TRUE, .backup = TRUE)
}
\arguments{
\item{...}{series of RStudio keyboard shortcuts to update. The argument
name is the keyboard shortcut, and the value is a string of the function
name that will execute. See examples.}

\item{.write_json}{logical indicating whether to update and overwrite
the existing JSON file of options. Default is \code{TRUE}. When \code{FALSE},
the function will return a list of all options, instead of writing
them to file.}

\item{.backup}{logical indicating whether to create a back-up of preferences
file before it's updated. Default is \code{TRUE}}
}
\value{
NULL, updates RStudio \code{addins.json} file
}
\description{
This function updates the RStudio keyboard shortcuts saved in
the \code{addins.json} file.
}
\examples{
if (interactive()) {
  use_rstudio_keyboard_shortcut(
    "Ctrl+Shift+/" = "rstudio.prefs::make_path_norm"
  )
}
}
\author{
Daniel D. Sjoberg
}
