/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.AbstractDiscretizationMethod;
import org.vikamine.kernel.data.discretization.AllValuesDiscretizer;
import org.vikamine.kernel.data.discretization.DiscretizationUtils;

public class EqualFreqDiscretizer
extends AbstractDiscretizationMethod {
    private static final String NAME = "Equal Frequency Discretizer";

    public EqualFreqDiscretizer() {
    }

    public EqualFreqDiscretizer(int segmentsCount) {
        this.segmentsCount = segmentsCount;
    }

    public EqualFreqDiscretizer(DataView population, NumericAttribute na, int segmentsCount) {
        this.population = population;
        this.attribute = na;
        this.segmentsCount = segmentsCount;
    }

    @Override
    public List<Double> getCutpoints() {
        if (this.attribute.getUsedValuesCount(this.population.dataset()) <= this.segmentsCount) {
            ArrayList<Double> result = new ArrayList<Double>();
            result.addAll(new AllValuesDiscretizer(this.population, this.attribute).getCutpoints());
            return result;
        }
        List<DataRecord> sortedDataRecords = DiscretizationUtils.getSortedDataRecords(this.population, this.attribute, false, false);
        double segmentSizeOptimum = (double)sortedDataRecords.size() / (double)this.segmentsCount;
        ArrayList<Double> cutpoints = new ArrayList<Double>(this.segmentsCount + 1);
        int counterSinceLastCandidate = 0;
        int counterSinceLastCutpoint = 0;
        double value = Double.NEGATIVE_INFINITY;
        double lastValue = Double.NEGATIVE_INFINITY;
        double secondLastDifferentValue = Double.NEGATIVE_INFINITY;
        Iterator<DataRecord> iterator = sortedDataRecords.iterator();
        while (iterator.hasNext()) {
            lastValue = value;
            DataRecord dr = iterator.next();
            if (lastValue != (value = dr.getValue(this.attribute))) {
                double differenceOfSegmentSizeForThisCandidate;
                double differenceOfSegmentSizeForLastCandidate = secondLastDifferentValue == Double.NEGATIVE_INFINITY ? Double.POSITIVE_INFINITY : Math.abs(segmentSizeOptimum - (double)counterSinceLastCutpoint);
                double d = differenceOfSegmentSizeForThisCandidate = lastValue == Double.NEGATIVE_INFINITY ? Double.POSITIVE_INFINITY : Math.abs(segmentSizeOptimum - (double)(counterSinceLastCutpoint += counterSinceLastCandidate));
                if (differenceOfSegmentSizeForLastCandidate < differenceOfSegmentSizeForThisCandidate) {
                    cutpoints.add((lastValue + secondLastDifferentValue) / 2.0);
                    if (cutpoints.size() == this.segmentsCount - 1) {
                        return cutpoints;
                    }
                    counterSinceLastCutpoint = counterSinceLastCandidate;
                }
                counterSinceLastCandidate = 0;
                secondLastDifferentValue = lastValue;
            }
            ++counterSinceLastCandidate;
        }
        return cutpoints;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<Double> getSortedSample() {
        return null;
    }
}

