/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import org.vikamine.kernel.util.ChildrenIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAccessor {
    public static String getNodeText(Node node) {
        StringBuffer buffy = new StringBuffer();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                buffy.append(child.getNodeValue().trim());
            }
            ++i;
        }
        return buffy.toString();
    }

    public static String getAllText(Node node) {
        ChildrenIterator iter = new ChildrenIterator(node);
        while (iter.hasNext()) {
            Node child = (Node)iter.next();
            if (child.getNodeType() != 4) continue;
            return child.getNodeValue();
        }
        StringBuffer sb = new StringBuffer();
        iter = new ChildrenIterator(node);
        while (iter.hasNext()) {
            Node child = (Node)iter.next();
            if (child.getNodeType() != 3) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static String getChildNodeText(Node node, String childElement) {
        StringBuffer buffy = new StringBuffer();
        if (!(node instanceof Element)) {
            throw new IllegalArgumentException("node is no element " + node);
        }
        NodeList children = ((Element)node).getElementsByTagName(childElement);
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            buffy.append(DOMAccessor.getNodeText(child));
            ++i;
        }
        return buffy.toString();
    }

    public static Node getChildNode(Node node, String nodeName) {
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equals(nodeName)) {
                return nl.item(i);
            }
            ++i;
        }
        return null;
    }

    public static String getNormalizedNodeValue(Node node) {
        String value = node.getNodeValue();
        return value.trim();
    }

    public static Element getFirstChildElement(Element elem, String tagName) {
        NodeList list = null;
        list = tagName == null ? elem.getChildNodes() : elem.getElementsByTagName(tagName);
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node instanceof Element) {
                    return (Element)node;
                }
                ++i;
            }
        }
        return null;
    }

    public static Element getFirstChildElement(Element elem) {
        return DOMAccessor.getFirstChildElement(elem, null);
    }
}

