% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsurfer.R
\name{normalise}
\alias{normalise}
\title{Normalise}
\usage{
normalise(data, normalisationFunction, fieldType = "all", trainData = NULL,
  testData = NULL)
}
\arguments{
\item{data}{The subject data to normalise}

\item{normalisationFunction}{The normalisation function to use, see details for further information.}

\item{fieldType}{The field set to normalise, see details for further information.}

\item{trainData}{Data to train on, required for 'hconly' normalisation methods}

\item{testData}{Unseen data, required for 'hconly' normalisation methods}
}
\value{
The normalised data
}
\description{
Performs ICV (intracranial volume) normalisation on a data frame of imported subjects in data.
}
\details{
Performs ICV (intracranial volume) normalisation on a data frame of imported subjects in data. The normalisationFunction specifies which normalisation method to use:

normalisation.proportional = proportional ICV normalisation, the volumes of each subject are divided by their ICV

normalisation.residual = residual ICV normalisation, a linear regression model is built for each volume using the ICV as a predictor

normalisation.residualgender = residual ICV normalisation with a gender split, similar to residual ICV normalisation, except a separate linear regression model is built for Males and Females

normalisation.residualhconly = residual ICV normalisation creating a regression model based on healthy control patients only

The fieldType can be:

corticalvolumes = Normalise cortical volumes by ICV

subcortical = Normalise subcortical volumes by ICV

hippocampal = Normalise hippocampal volumes by ICV

corticalareas = Normalise cortical areas by ICV

corticalthicknesses = Normalise cortical thicknesses by ICV

corticalthicknessstds = Normalise cortical thicknesses standard deviations by ICV

corticalareastsa = Normalise cortical areas by total surface area

corticalthicknessesmct = Normalise cortical thicknesses by mean cortical thickness
}
\examples{
data <- generaterandomsubjects()
addrandomgender(data)
}
\author{
Alexander Luke Spedding, \email{alexspedding271@gmail.com}
}
