% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_html.R
\name{as_html}
\alias{as_html}
\title{Convert an \code{rtable} object to a \code{shiny.tag} html object}
\usage{
as_html(
  x,
  width = NULL,
  class_table = "table table-condensed table-hover",
  class_tr = "",
  class_td = "",
  class_th = ""
)
}
\arguments{
\item{x}{\code{rtable} object}

\item{width}{width}

\item{class_table}{class for table tag}

\item{class_tr}{class for tr tag}

\item{class_td}{class for td tag}

\item{class_th}{class for th tag}
}
\value{
A \code{shiny.tag} object representing \code{x} in HTML.
}
\description{
The returned \code{html} object can be immediately used in shiny and rmarkdown.
}
\examples{

tbl <- rtable(
  header = LETTERS[1:3],
  format = "xx",
  rrow("r1", 1,2,3),
  rrow("r2", 4,3,2, indent = 1),
  rrow("r3", indent = 2)
)

as_html(tbl)

as_html(tbl, class_table = "table", class_tr = "row")

as_html(tbl, class_td = "aaa")

if(interactive()) {
Viewer(tbl)
}
}
