% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\docType{class}
\name{VarStaticCutSplit-class}
\alias{VarStaticCutSplit-class}
\alias{make_static_cut_split}
\alias{CumulativeCutSplit-class}
\alias{VarDynCutSplit-class}
\alias{VarDynCutSplit}
\title{Splits for cutting by values of a numeric variable}
\usage{
make_static_cut_split(
  var,
  split_label,
  cuts,
  cutlabels = NULL,
  cfun = NULL,
  cformat = NULL,
  cna_str = NA_character_,
  split_format = NULL,
  split_na_str = NA_character_,
  split_name = var,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  indent_mod = 0L,
  cindent_mod = 0L,
  cvar = "",
  cextra_args = list(),
  label_pos = "visible",
  cumulative = FALSE,
  page_prefix = NA_character_,
  section_div = NA_character_
)

VarDynCutSplit(
  var,
  split_label,
  cutfun,
  cutlabelfun = function(x) NULL,
  cfun = NULL,
  cformat = NULL,
  cna_str = NA_character_,
  split_format = NULL,
  split_na_str = NA_character_,
  split_name = var,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  cumulative = FALSE,
  indent_mod = 0L,
  cindent_mod = 0L,
  cvar = "",
  cextra_args = list(),
  label_pos = "visible",
  page_prefix = NA_character_,
  section_div = NA_character_
)
}
\arguments{
\item{var}{(\code{string})\cr variable name.}

\item{split_label}{(\code{string})\cr label to be associated with the table generated by the split. Not to be confused
with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{cuts}{(\code{numeric})\cr cuts to use.}

\item{cutlabels}{(\code{character} or \code{NULL})\cr labels for the cuts.}

\item{cfun}{(\code{list}, \code{function}, or \code{NULL})\cr tabulation function(s) for creating content rows. Must accept \code{x}
or \code{df} as first parameter. Must accept \code{labelstr} as the second argument. Can optionally accept all optional
arguments accepted by analysis functions. See \code{\link[=analyze]{analyze()}}.}

\item{cformat}{(\code{string}, \code{function}, or \code{list})\cr format for content rows.}

\item{cna_str}{(\code{character})\cr NA string for use with \code{cformat} for content table.}

\item{split_format}{(\code{string}, \code{function}, or \code{list})\cr default format associated with the split being created.}

\item{split_na_str}{(\code{character})\cr NA string vector for use with \code{split_format}.}

\item{split_name}{(\code{string})\cr name associated with the split (for pathing, etc.).}

\item{child_labels}{(\code{string})\cr the display behavior for the labels (i.e. label rows) of the children of this
split. Accepts \code{"default"}, \code{"visible"}, and \code{"hidden"}. Defaults to \code{"default"} which flags the label row as
visible only if the child has 0 content rows.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{cindent_mod}{(\code{numeric(1)})\cr the indent modifier for the content tables generated by this split.}

\item{cvar}{(\code{string})\cr the variable, if any, that the content function should accept. Defaults to \code{NA}.}

\item{cextra_args}{(\code{list})\cr extra arguments to be passed to the content function when tabulating row group
summaries.}

\item{label_pos}{(\code{string})\cr location where the variable label should be displayed. Accepts \code{"hidden"}
(default for non-analyze row splits), \code{"visible"}, \code{"topleft"}, and \code{"default"} (for analyze splits only). For
\code{analyze} calls, \code{"default"} indicates that the variable should be visible if and only if multiple variables are
analyzed at the same level of nesting.}

\item{cumulative}{(\code{flag})\cr whether the cuts should be treated as cumulative. Defaults to \code{FALSE}.}

\item{page_prefix}{(\code{string})\cr prefix to be appended with the split value when forcing pagination between
the children of a split/table.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group defined
by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{cutfun}{(\code{function})\cr function which accepts the \emph{full vector} of \code{var} values and returns cut points to be
used (via \code{cut}) when splitting data during tabulation.}

\item{cutlabelfun}{(\code{function})\cr function which returns either labels for the cuts or \code{NULL} when passed the
return value of \code{cutfun}.}
}
\value{
A \code{VarStaticCutSplit}, \code{CumulativeCutSplit} object for \code{make_static_cut_split}, or a \code{VarDynCutSplit}
object for \code{\link[=VarDynCutSplit]{VarDynCutSplit()}}.
}
\description{
Splits for cutting by values of a numeric variable

Create static cut or static cumulative cut split
}
