% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysVarPlots.R
\name{sysVarInPlots}
\alias{sysVarInPlots}
\title{Produces plots for interpreting the results from sysVarIn.}
\usage{
sysVarInPlots(
  fullData,
  sysVar_name,
  sysVarType,
  n_profiles,
  testModel = NULL,
  dist0name = NULL,
  dist1name = NULL,
  printPlots = T
)
}
\arguments{
\item{fullData}{A dataframe created by the "makeFullData" function.}

\item{sysVar_name}{The name of the variable in the dataframe that contains the system variable.}

\item{sysVarType}{Whether the system variable is "dyadic", which means both partners have the same score, or "indiv" which means the partners can have different scores}

\item{n_profiles}{The number of latent profiles.}

\item{testModel}{The name of the model that is being interpreted (e.g., sysIn$models$sysVarInteract). Only needed when the system variable is "indiv" (e.g., individual scores for each partner)}

\item{dist0name}{An optional name for the level-0 of the distinguishing variable (e.g., "Women"). Default is dist0.}

\item{dist1name}{An optional name for the level-1 of the distinguishing variable (e.g., "Men"). Default is dist1}

\item{printPlots}{If true (the default) plots are displayed on the screen.}
}
\value{
Single plots or a list of plots (depending on the model that is being interpreted).
}
\description{
Produces plots for interpreting the results from sysVarIn.
}
\examples{
data <- rties_ExampleDataShort
newData <- dataPrep(basedata=data, dyadId="couple", personId="person", 
obs_name="dial", dist_name="female", time_name="time", time_lag=2)
ic <- indivInertCoord(prepData=newData, whichModel="inertCoord")
profiles <- inspectProfiles(whichModel="inertCoord", prepData=newData, 
paramEst=ic$params, n_profiles=2)
fullData <- makeFullData(basedata=data, dyadId="couple", personId="person", 
dist_name="female", lpaData=profiles, params=ic$params)
sysIn <- sysVarIn(fullData=fullData, sysVar_name="conflict", sysVarType="indiv", n_profiles=2)
sysVarInPlots(fullData=fullData, sysVar_name="conflict", sysVarType="indiv", 
n_profiles=2, testModel=sysIn$models$sysVarInteract)

}
