% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_flow_frames.R
\name{ts_flow_frames}
\alias{ts_flow_frames}
\title{Create a series of charts of a raster time series}
\usage{
ts_flow_frames(
  r_list,
  positions = NULL,
  position_names = NULL,
  band_names = NULL,
  band_colors = NULL,
  val_min = NULL,
  val_max = NULL,
  val_by = NULL,
  plot_size = 1,
  position_legend = NULL,
  legend_position = "right",
  band_legend = NULL,
  band_legend_title = NULL,
  position_legend_title = NULL,
  pbuffer = NULL,
  plot_function = "line",
  aes_by_pos = TRUE,
  FUN = mean,
  return_df = FALSE,
  ...
)
}
\arguments{
\item{r_list}{list of rasters, as generated by \code{\link{ts_raster}}.}

\item{positions}{(Optional) object containing the coordinates. One of \itemize{
 \item{A two-column \code{matrix} of coordinates where the first column corresponds to the longitude and the second column corresponds to the latitude.}
 \item{A \code{SpatialPolygonsDataFrame} }
 \item{A \code{SpatialPointsDataFrame} }
 \item{An sf object containing \code{POINTS},\code{POLYGONS} or \code{MULTIPOLYGONS}}
}If no positions are specified, one position is assumed to be the entire extent of the rasters.}

\item{position_names}{(Optional) character, names of the positions to be added in legend or text. By default, will create placeholder names by combining the object type and Id (Example: "Polygon 3")}

\item{band_names}{(Optional) character, names of the bands to be added in legend, if \code{band_legend}. By default, will create placeholder names by band index (Example: "Band 3").}

\item{band_colors}{(Optional) character, colors which represent the bands in the plot. Must be in matching order to \code{band_names}. If \code{r_list} is discrete, the colors will be mapped to the different levels.  By default will use ggplot colors.}

\item{val_min}{(Optional) numeric, minimum value of the y-axis. By default chooses a rounded minimum value of the rasters contained within \code{r_list}.}

\item{val_max}{(Optional) numeric, maximum value of the y-axis. By default chooses a rounded maximum value of the rasters contained within \code{r_list}.}

\item{val_by}{(Optional) numeric, interval value of the y-axis. Default is \code{0.1}.}

\item{plot_size}{(Optional) numeric, size for the ggplot objects. Default is \code{1}.}

\item{position_legend}{(Optional) logical. If \code{TRUE}: Add a legend for the positions. Only recommended if \code{aes_by_pos} is also  \code{TRUE}.}

\item{legend_position}{(Optional) character, position of the legend. Use \code{"none"} to disable all legends. Default is \code{"right"}.}

\item{band_legend}{(Optional) logical. If \code{TRUE}: Add a legend for the bands. Default is \code{TRUE}.}

\item{band_legend_title}{(Optional) character, title of the band legend. Default is \code{"Bands"}.}

\item{position_legend_title}{(Optional) character, title of the band legend. Default is \code{"Positions"}.}

\item{pbuffer}{(Optional) numeric. The radius of a buffer around each object which will be applied before extraction. By default, no buffer is used.}

\item{plot_function}{(Optional) character or function, type of the plots to produce. Currently supported are \code{"line"}, \code{"line_flp"} and \code{"violin"}. Alternatively, a custom function with similar structure and arguments can be passed to create other types of plots. Default is \code{"line"}.}

\item{aes_by_pos}{(Optional) logical. If \code{TRUE}: vary the linetype aesthetic to be different for each position? If  \code{FALSE}, this also disables the \code{position_legend}, as no notable classes will be plotted. Default is \code{TRUE}.}

\item{FUN}{(Optional) function to summarize the values (e.g. mean) during the extraction. See \link[raster]{extract} for more details. Default is \code{"mean"}. For some \code{plot_function} which map the full distribution of values the FUN is ignored.}

\item{return_df}{(Optional) logical. Return a dataframe with the extracted values instead of a plot? This can be useful for experimenting with plot creation. Default is \code{FALSE}.}

\item{...}{(Optional) additional arguments for \code{plot_function}.}
}
\value{
A list of ggplots, one for each element of \code{r_list}.
}
\description{
Create a series of charts of a raster time series
}
\details{
Values are extracted using \link[raster]{extract} and plotted on a \link[ggplot2]{ggplot}.
 The type of the ggplot is specified by \code{plot_function}. Currently supported are \code{"line"} and \code{"violin"} as well as custom functions which accept similar inputs.
 The function may fail for large polygons and long time series. Be aware that if \code{\link{ts_raster}} is used with \code{fade}, interpolation may be used to generate raster values.
}
\examples{
#' #Setup
library(rtsVis)
# Load example dataset at a greatly increased interval
x_list <- MODIS_SI_ds[seq(1,length(MODIS_SI_ds),30)]
x_dates <- do.call(c, lapply(MODIS_SI_ds,attr,"time") )[seq(1,length(MODIS_SI_ds),30)]

#Fill NAs
x_list_filled <- ts_fill_na(x_list)

#Make a sequence of output dates, double the length of input dates
out_dates <-seq.POSIXt(from = x_dates[1],
                       to = x_dates[length(x_dates)],length.out = length(x_dates)*2 )

#For each output date, interpolate a raster image from the input files
r_list_out <- ts_raster(r_list = x_list_filled,
                        r_times = x_dates,
                        out_times = out_dates,
                        fade_raster = TRUE)
#Create the frames 
# as from the desired layers
r_frames <- ts_makeframes(x_list = r_list_out,samplesize = 10,
                          l_indices = c(1,4,3))

# Create a line plot from the data extracted over points
points <- SI_positions$points #Polygons of Slovenian municipalities covered by the raster
flow_frames_point_line <- rtsVis::ts_flow_frames(r_list = r_list_out,
 position_names = c("Ljubljana","Ivančna Gorica","Dolenjske Toplice","Loški Potok"),
 band_names = c("620 - 670","841 - 876","459 - 479","545 - 565"),
 positions = points,
 band_colors = c("firebrick3","darkorchid3","dodgerblue3","olivedrab3"),
           band_legend_title = "Wavelength [nm]",
           position_legend_title = "Občina",
           legend_position = "bottom",
           position_legend = FALSE,
           band_legend=TRUE,aes_by_pos = TRUE)

#Check one of the frames
flow_frames_point_line[[5]]


# Create a violin plot from the data extracted over polygons
# polygons <- SI_positions$polygons
#flow_frames_poly_vio <-
#rtsVis::ts_flow_frames(r_list = r_list_out,
#           position_names = c("Radece","Ljubljana","Kocevje"),
#           band_names = c("620 - 670","841 - 876","459 - 479","545 - 565"),
#           positions = polygons,
#           band_colors = c("firebrick3","darkorchid3","dodgerblue3","olivedrab3"),
#           band_legend_title = "Wavelength [nm]",
#           position_legend_title = "Občina",
#           position_legend = FALSE,
#          legend_position = "left",
#           band_legend=TRUE,aes_by_pos = FALSE,
#          plot_function = "violin")
#Check one of the frames
# flow_frames_poly_vio[[5]]

}
\seealso{
\code{\link{ts_raster}}
}
\author{
Johannes Mast
}
