% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_users}
\alias{search_users}
\title{search_users}
\usage{
search_users(q, n = 20, parse = TRUE, clean_tweets = FALSE,
  as_double = FALSE, token = NULL, verbose = TRUE)
}
\arguments{
\item{q}{Character, search query of no greater than
500 characters maximum.}

\item{n}{Numeric, specifying the total number of desired users to
return. Defaults to 100. Maximum number of users returned from
a single search is 1,000.}

\item{parse}{Logical, indicating whether to return parsed
(data.frames) or nested list (fromJSON) object. By default,
\code{parse = TRUE} saves users from the time
[and frustrations] associated with disentangling the Twitter
API return objects.}

\item{clean_tweets}{logical indicating whether to remove non-ASCII
characters in text of tweets. defaults to FALSE.}

\item{as_double}{logical indicating whether to handle ID variables
as double (numeric) class. By default, this is set to FALSE, meaning
ID variables are treated as character vectors. Setting this to
TRUE can provide performance (speed and memory) boost but can also
lead to issues when printing and saving, depending on the format.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find instructions
on how to create tokens and setup an environment variable in the
tokens vignette (in r, send \code{?tokens} to console).}

\item{verbose}{Logical, indicating whether or not to output
processing/retrieval messages.}
}
\value{
Data frame of users returned by query.
}
\description{
Returns data frame of users data using a provided
  search query.
}
\examples{
\dontrun{
# search for 1000 tweets mentioning Hillary Clinton
pc <- search_users(q = "political communication", n = 1000)

# data frame where each observation (row) is a different user
pc

# tweets data also retrieved. can access it via tweets_data()
users_data(hrc)
}
}
\seealso{
\url{https://dev.twitter.com/overview/documentation}

Other users: \code{\link{lookup_users}},
  \code{\link{users_data}}
}

