% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mentions.R
\name{get_mentions}
\alias{get_mentions}
\title{Get mentions for the authenticating user.}
\usage{
get_mentions(
  n = 200,
  since_id = NULL,
  max_id = NULL,
  parse = TRUE,
  retryonratelimit = NULL,
  verbose = TRUE,
  token = NULL,
  ...
)
}
\arguments{
\item{n}{Desired number of results to return. Results are downloaded
in pages when \code{n} is large; the default value will download a single
page. Set \code{n = Inf} to download as many results as possible.

The Twitter API rate limits the number of requests you can perform
in each 15 minute period. The easiest way to download more than that is
to use \code{retryonratelimit = TRUE}.

You are not guaranteed to get exactly \code{n} results back. You will get
fewer results when tweets have been deleted or if you hit a rate limit.
You will get more results if you ask for a number of tweets that's not
a multiple of page size, e.g. if you request \code{n = 150} and the page
size is 200, you'll get 200 results back.}

\item{since_id}{Supply a vector of ids or a data frame of previous results to
find tweets \strong{newer} than \code{since_id}.}

\item{max_id}{Supply a vector of ids or a data frame of previous results to
find tweets \strong{older} than \code{max_id}.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{retryonratelimit}{If \code{TRUE}, and a rate limit is exhausted, will wait
until it refreshes. Most Twitter rate limits refresh every 15 minutes.
If \code{FALSE}, and the rate limit is exceeded, the function will terminate
early with a warning; you'll still get back all results received up to
that point. The default value, \code{NULL}, consults the option
\code{rtweet.retryonratelimit} so that you can globally set it to \code{TRUE},
if desired.

If you expect a query to take hours or days to perform, you should not
rely soley on \code{retryonratelimit} because it does not handle other common
failure modes like temporarily losing your internet connection.}

\item{verbose}{Show progress bars and other messages indicating current
progress?}

\item{token}{Expert use only. Use this to override authentication for
a single API call. In most cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{...}{Other arguments passed as parameters in composed API
query.}
}
\value{
Tibble of mentions data.
}
\description{
Returns data on up to 200 of the most recent mentions (Tweets
containing a users' screen_name) of the authenticating user.
The timeline returned is the equivalent of the one seen when you view
your mentions on twitter.com.
}
\examples{
if (auth_has_default()) {
tw <- get_mentions()
tw

# newer mentions
get_mentions(since_id = tw)
}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/v1/tweets/timelines/overview}
}
\seealso{
Other tweets: 
\code{\link{get_favorites}()},
\code{\link{get_timeline}()},
\code{\link{lists_statuses}()},
\code{\link{lookup_tweets}()},
\code{\link{search_tweets}()}
}
\concept{tweets}
