% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_pipelines.R
\name{bootstrap_rho}
\alias{bootstrap_rho}
\title{Perform a parametric bootstrapping correction on an estimated rho vector}
\usage{
bootstrap_rho(rho_est, pi_est, D, gen_start_col, niter = 100, reps = 2000,
  burn_in = 100)
}
\arguments{
\item{rho_est}{the rho value previously estimated from MCMC GSI from the
provided reference and mixture data}

\item{pi_est}{the pi value previously estimated from MCMC GSI from the
provided reference and mixture data}

\item{D}{a two-column genetic dataframe containing the reference and mixture
data from which \code{rho_est} was computed; with "repunit", "collection",
and "indiv" columns}

\item{gen_start_col}{the first column of genetic data in D. All columns after
\code{gen_start_col} must be genetic data

In parametric bootstrapping, \code{niter} new mixture datasets are simulated by
individual from the reference with reporting unit proportions \code{rho_est},
and the mean of their MCMC GSI outputs is used to calculate an average bias.
This bias is subtracted from rho_est to give the output. The number of individuals
in each simulated bootstrap dataset is equal to the number of "mixture" individuals
in \code{D}.}
}
\value{
\code{bootstrap_rho} returns a new rho value, corrected by parametric
bootstrapping.
}
\description{
Takes an estimate of rho, and a two-column format genetic data frame
containing both reference and mixture data. Returns a new rho corrected by
parametric bootstrapping
}
\keyword{internal}
