% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_path.R
\name{plot_path}
\alias{plot_path}
\title{Plot a path of the simulated ruin process}
\usage{
plot_path(path_object)
}
\arguments{
\item{path_object}{an S4 object of *Path class (e.g.,
\linkS4class{PathCramerLundberg}).}
}
\value{
A \code{\link{ggplot2}} object.
}
\description{
\code{plot_path()} takes a simulated ruin process as the argument and plots
its path.
}
\details{
Under the hood, the function uses \code{\link{ggplot2}} package, therefore,
all functionality from \code{\link{ggplot2}} is available.
}
\examples{
model <- CramerLundberg(initial_capital = 10,
                        premium_rate = 1,
                        claim_poisson_arrival_rate = 1,
                        claim_size_generator = rexp,
                        claim_size_parameters = list(rate = 1))

path <- simulate_path(model = model, max_time_horizon = 10)

plot_path(path)

}
