% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_diagnostics.R
\name{print.summary.ru}
\alias{print.summary.ru}
\title{Print method for objects of class "summary.ru"}
\usage{
\method{print}{summary.ru}(x, ...)
}
\arguments{
\item{x}{an object of class "summary.ru", a result of a call to
\code{\link{summary.ru}}.}

\item{...}{Additional optional arguments to be passed to
\code{\link{print}}.}
}
\value{
Prints
\itemize{
  \item {a summary of the simulated values, via
    \code{summary(object$sim_vals)}}
  \item {an estimate of the probability of acceptance, i.e.
    \code{object$pa}}
  \item {information about the ratio-of-uniforms bounding box, i.e.
    \code{object$box}}
}
}
\description{
\code{print} method for an object \code{object} of class "summary.ru".
}
\examples{
# one-dimensional standard normal ----------------
x <- ru(logf = function(x) -x ^ 2 / 2, d = 1, n = 1000, init = 0)
summary(x)

# two-dimensional normal with positive association ----------------
rho <- 0.9
covmat <- matrix(c(1, rho, rho, 1), 2, 2)
log_dmvnorm <- function(x, mean = rep(0, d), sigma = diag(d)) {
  x <- matrix(x, ncol = length(x))
  d <- ncol(x)
  - 0.5 * (x - mean) \%*\% solve(sigma) \%*\% t(x - mean)
}
x <- ru(logf = log_dmvnorm, sigma = covmat, d = 2, n = 1000, init = c(0, 0))
summary(x)
}
\seealso{
\code{\link{ru}} for descriptions of \code{object$sim_vals} and
  \code{object$box}.

\code{\link{plot.ru}} for a diagnostic plot.
}
