% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{encoding}
\alias{encoding}
\alias{guess_encoding}
\alias{repair_encoding}
\title{Guess and repair faulty character encoding.}
\usage{
guess_encoding(x)

repair_encoding(x, from = NULL)
}
\arguments{
\item{x}{A character vector.}

\item{from}{The encoding that the string is actually in. If \code{NULL},}
}
\description{
These functions help you respond to web pages that declare incorrect
encodings. You can use \code{guess_encoding} to figure out what
the real encoding is (and then supply that to the \code{encoding} argument of
html), or use \code{repair_encoding} to fix character vectors after the
fact.
}
\section{stringi}{


These function are wrappers around tools from the fantastic stringi
package, so you'll need to make sure to have that installed.
}
\examples{
\donttest{
# This page claims to be in iso-8859-1:
url <- 'http://www.elections.ca/content.aspx?section=res&dir=cir/list&document=index&lang=e#list'
elections <- read_html(url)
x <- elections \%>\% html_nodes("table") \%>\% .[[2]] \%>\% html_table() \%>\% .$TO
# But something looks wrong:
x

# It's acutally UTF-8!
guess_encoding(x)

# We can repair this vector:
repair_encoding(x)

# But it's better to start from scratch with correctly encoded file
elections <- read_html(url, encoding = "UTF-8")
elections \%>\% html_nodes("table") \%>\% .[[2]] \%>\% html_table() \%>\% .$TO
}
}

