% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vine.R
\name{vine}
\alias{vine}
\alias{vine_dist}
\title{Vine copula models}
\usage{
vine(data, margins_controls = list(mult = NULL, xmin = NaN, xmax = NaN,
  bw = NA), copula_controls = list(family_set = "all", structure = NA,
  par_method = "mle", nonpar_method = "constant", mult = 1, selcrit =
  "bic", psi0 = 0.9, presel = TRUE, trunc_lvl = Inf, tree_crit = "tau",
  threshold = 0, keep_data = FALSE, show_trace = FALSE, cores = 1),
  keep_data = FALSE)

vine_dist(margins, pair_copulas, structure)
}
\arguments{
\item{data}{a matrix or data.frame.}

\item{margins_controls}{a list with arguments to be passed to
\code{\link[kde1d:kde1d]{kde1d::kde1d()}}. Currently, there can be
\itemize{
\item \code{mult} numeric; all bandwidths for marginal kernel density estimation
are multiplied with \code{mult_1d}. Defaults to \code{log(1 + d)} where \code{d} is
the number of variables after applying \code{\link[cctools:expand_as_numeric]{cctools::expand_as_numeric()}}.
\item \code{xmin} numeric vector of length d; see \code{\link[kde1d:kde1d]{kde1d::kde1d()}}.
\item \code{xmax} numeric vector of length d; see \code{\link[kde1d:kde1d]{kde1d::kde1d()}}.
\item \code{bw} numeric vector of length d; see \code{\link[kde1d:kde1d]{kde1d::kde1d()}}.
}}

\item{copula_controls}{a list with arguments to be passed to \code{\link[=vinecop]{vinecop()}}.}

\item{keep_data}{whether the original data should be stored; if you want to
store the pseudo-observations used for fitting the copula, use the
\code{copula_controls} argument.}

\item{margins}{A list with with each element containing the specification of a
marginal \link[stats:Distributions]{stats::Distributions}. Each marginal specification
should be a list with containing at least the distribution family (\code{"distr"})
and optionally the parameters, e.g.
\code{list(list(distr = "norm"), list(distr = "norm", mu = 1), list(distr = "beta", shape1 = 1, shape2 = 1))}.
Note that parameters that have no default values have to be provided.
Furthermore, if \code{margins} has length one, it will be recycled for every component.}

\item{pair_copulas}{A nested list of 'bicop_dist' objects, where
\code{pair_copulas[[t]][[e]]} corresponds to the pair-copula at edge \code{e} in
tree \code{t}.}

\item{structure}{an \code{rvine_structure} object, namely a compressed
representation of the vine structure, or an object that can be coerced
into one (see \code{\link[=rvine_structure]{rvine_structure()}} and \code{\link[=as_rvine_structure]{as_rvine_structure()}}).
The dimension must be \code{length(pair_copulas[[1]]) + 1}.}
}
\value{
Objects inheriting from \code{vine_dist} for \code{\link[=vine_dist]{vine_dist()}}, and
\code{vine} and \code{vine_dist} for \code{\link[=vine]{vine()}}.

Objects from the \code{vine_dist} class are lists containing:
\itemize{
\item \code{margins}, a list of marginals (see below).
\item \code{copula}, an object of the class \code{vinecop_dist}, see \code{\link[=vinecop_dist]{vinecop_dist()}}.
}

For objects from the \code{vine} class, \code{copula} is also an object of the class
\code{vine}, see \code{\link[=vinecop]{vinecop()}}. Additionally, objects from the \code{vine} class contain:
\itemize{
\item \code{margins_controls}, a \code{list} with the set of fit controls that was passed
to \code{\link[kde1d:kde1d]{kde1d::kde1d()}} when estimating the margins.
\item \code{copula_controls}, a \code{list} with the set of fit controls that was passed
to \code{\link[=vinecop]{vinecop()}} when estimating the copula.
\item \code{data} (optionally, if \code{keep_data = TRUE} was used), the dataset that was
passed to \code{\link[=vine]{vine()}}.
\item \code{nobs}, an \code{integer} containing the number of observations that was used
to fit the model.
}

Concerning \code{margins}:
\itemize{
\item For objects created with \code{\link[=vine_dist]{vine_dist()}}, it simply corresponds to the \code{margins}
argument.
\item For objects created with \code{\link[=vine]{vine()}}, it is a list of objects of class \code{kde1d},
see \code{\link[kde1d:kde1d]{kde1d::kde1d()}}.
}
}
\description{
Automated fitting or creation of custom vine copula models
}
\details{
\code{vine_dist()} creates a vine copula by specifying the margins, a nested list
of \code{bicop_dist} objects and a quadratic structure matrix.

\code{vine()} provides automated fitting for vine copula models.
\code{margins_controls} is a list with the same parameters as
\code{\link[kde1d:kde1d]{kde1d::kde1d()}} (except for \code{x}). \code{copula_controls} is a list
with the same parameters as \code{\link[=vinecop]{vinecop()}} (except for \code{data}).
}
\examples{
# specify pair-copulas
bicop <- bicop_dist("bb1", 90, c(3, 2))
pcs <- list(
  list(bicop, bicop), # pair-copulas in first tree
  list(bicop) # pair-copulas in second tree
)

# specify R-vine matrix
mat <- matrix(c(1, 2, 3, 1, 2, 0, 1, 0, 0), 3, 3)

# set up vine copula model with Gaussian margins
vc <- vine_dist(list(distr = "norm"), pcs, mat)

# show model
summary(vc)

# simulate some data
x <- rvine(50, vc)

# estimate a vine copula model
fit <- vine(x, copula_controls = list(family_set = "par"))
summary(fit)
}
