% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxivistr.R
\name{rxivist_search}
\alias{rxivist_search}
\title{Search Rxivist}
\usage{
rxivist_search(
  search_phrase = "",
  from = "alltime",
  category = "",
  sortby = "downloads",
  limit = 20
)
}
\arguments{
\item{search_phrase}{Search phrase used for finding articles. Can be left empty.}

\item{from}{Defines what timeframe to search. Can be alltime, ytd, lastmonth, day, week, month, year. Lastmonth and ytd can only be used with sortby set as downloads}

\item{category}{Filters out results not related to the specified category. Category list can be viewed with category_list function. If filtering for a single category, this category can be specified as a string. If filtering for multiple categories, argument must be specified as a vector, e.g. category = c("zoology","biophysics").}

\item{sortby}{Sorts the results based on the number of downloads or twitter statistics.}

\item{limit}{Number of results to retrieve.}
}
\value{
Returns a data frame with articles matching specified search criteria.
}
\description{
Retrieves a articles with matching description.
}
\examples{
rxivist_search(search_phrase = "T-cells", from = "alltime", sortby = "twitter", limit = 5)
}
