% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Season.R
\name{Season}
\alias{Season}
\title{Compute seasonal mean}
\usage{
Season(data, time_dim = "sdate", monini, moninf, monsup, method = mean,
  na.rm = TRUE, ncores = NULL)
}
\arguments{
\item{data}{A named numeric array with at least one dimension 'time_dim'.}

\item{time_dim}{A character string indicating the name of dimension along
which the seasonal means are computed. The default value is 'sdate'.}

\item{monini}{An integer indicating what the first month of the time series is. 
It can be from 1 to 12.}

\item{moninf}{An integer indicating the starting month of the seasonal mean. 
It can be from 1 to 12.}

\item{monsup}{An integer indicating the end month of the seasonal mean. It 
can be from 1 to 12.}

\item{method}{An R function to be applied for seasonal calculation. For
example, 'sum' can be used for total precipitation. The default value is mean.}

\item{na.rm}{A logical value indicating whether to remove NA values along 
'time_dim' when calculating climatology (TRUE) or return NA if there is NA 
along 'time_dim' (FALSE). The default value is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
An array with the same dimensions as data except along the 'time_dim' 
 dimension, of which the length changes to the number of seasons.
}
\description{
Compute the seasonal mean (or other methods) on monthly time series along
one dimension of a named multi-dimensional arrays. Partial season is not 
accounted.
}
\examples{
set.seed(1)
dat1 <- array(rnorm(144*3), dim = c(member = 2, sdate = 12*3, ftime = 2, lon = 3))
res <- Season(data = dat1, monini = 1, moninf = 1, monsup = 2)
res <- Season(data = dat1, monini = 10, moninf = 12, monsup = 2)
dat2 <- dat1
set.seed(2)
na <- floor(runif(30, min = 1, max = 144*3))
dat2[na] <- NA
res <- Season(data = dat2, monini = 3, moninf = 1, monsup = 2)
res <- Season(data = dat2, monini = 3, moninf = 1, monsup = 2, na.rm = FALSE)
}

