% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_anomaly_score.R
\name{compute_anomaly_score}
\alias{compute_anomaly_score}
\title{Compute anomaly scores}
\usage{
compute_anomaly_score(obj, x, window_size = 1L, ...)
}
\arguments{
\item{obj}{object}

\item{x}{data.frame to compute anomaly scores}

\item{window_size}{integer.}

\item{...}{additional arguments}
}
\value{
matrix of anomaly scores
}
\description{
Compute anomaly scores
}
\examples{
library(sGMRFmix)

set.seed(314)
train_data <- generate_train_data()
fit <- sGMRFmix(train_data, K = 7, rho = 10)

test_data <- generate_test_data()
compute_anomaly_score(fit, test_data)

}
