#' @title Sample Data for Small Area Estimation using Hierarchical Bayesian Method under Beta distribution
#'
#' @description Dataset to simulate Small Area Estimation using Hierarchical Bayesian Method under Beta distribution
#'
#' This data is generated by these following steps:
#'
#' \enumerate{
#'   \item Generate sampling random area effect \code{u} with  \code{u ~ N(0,1)}. The auxiliary variables are generated by uniform distribution with  \code{x1 ~ U(0,1)} and  \code{x2 ~ U(1,5)}. The coefficient parameters \eqn{ \beta_{0}, \beta_{1}, and \beta_{2}}{\beta0, \beta1, \beta2} are set with a certain values. we set \eqn{\pi = 1}.
#'   \cr Calculate \eqn{\mu}{\mu} = \eqn{exp(\beta_{0} + x_{1}\beta_{1} + x_{2}\beta_{2}+u)}{exp(\beta0 + x1\beta1+x1\beta2} / \eqn{1+exp(\beta_{0} + x_{1}\beta_{1} + x_{2}\beta_{2}+u)}{1+exp(\beta0 + x1\beta1+x1\beta2+1)}
#'   \cr For parameter of Beta Distribution, we set \eqn{\pi} = 1, then calculate \eqn{A = \mu\pi}{mu*pi} and \eqn{B=(1-\mu)\pi}{B=1-mu.pi}
#'   \cr Generate direct estimate with  \code{y ~ Beta(A,B)}
#'   \cr Calculate the variance of \code{y} with \code{var(y)}{varY} = \code{{A.B}/{((A+B+1)*(A+B)^2)}}
#'   \item Auxiliary variables \code{x1,x2}, direct estimation \code{(y)} and vardir are combined in a dataframe called \code{dataBeta}
#'
#' }
#'
#'
#' @format A data frame with 50 rows and 4 variables:
#' \describe{
#'   \item{y}{Direct Estimation of y}
#'   \item{x1}{Auxiliary variable of x1}
#'   \item{x2}{Auxiliary variable of x2}
#'   \item{vardir}{Sampling Variance of y}
#' }
#'

"dataBeta"
