% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/SaemixObject.R
\docType{methods}
\name{psi-methods}
\alias{psi-methods}
\alias{phi-methods}
\alias{eta-methods}
\alias{phi,SaemixObject-method}
\alias{eta,SaemixObject-method}
\alias{psi,SaemixObject-method}
\alias{psi}
\alias{phi}
\alias{eta}
\alias{psi.SaemixObject}
\alias{psi.saemix}
\alias{phi.SaemixObject}
\alias{eta.SaemixObject}
\alias{phi.saemix}
\alias{eta.saemix}
\title{Functions to extract the individual estimates of the parameters and random
effects}
\usage{
psi(object, type = c("mode", "mean"))

phi(object, type = c("mode", "mean"))

eta(object, type = c("mode", "mean"))

\S4method{psi}{SaemixObject}(object, type = c("mode", "mean"))

\S4method{phi}{SaemixObject}(object, type = c("mode", "mean"))

\S4method{eta}{SaemixObject}(object, type = c("mode", "mean"))
}
\arguments{
\item{object}{an SaemixObject object returned by the \code{\link{saemix}} function}

\item{type}{a string specifying whether to use the MAP (type="mode") or the mean (type="mean")
of the conditional distribution of the individual parameters. Defaults to mode}
}
\value{
a matrix with the individual parameters (psi/phi) or the random effects (eta).
These functions are used to access and output the estimates of
parameters and random effects. When the object passed to the function does
not contain these estimates, they are automatically computed. The object is
then returned (invisibly) with these estimates added to the results.
}
\description{
These three functions are used to access the estimates of individual
parameters and random effects.
}
\details{
The psi_i represent the individual parameter estimates. In the SAEM
algorithm, these parameters are assumed to be a transformation of a Gaussian
random vector phi_i, where the phi_i can be written as a function of the
individual random effects (eta_i), the covariate matrix (C_i) and the vector
of fixed effects (mu):

phi_i = C_i mu + eta_i

More details can be found in the PDF documentation.
}
\section{Methods}{
 \describe{
\item{list("signature(object = \"SaemixObject\")")}{ please refer to the PDF
documentation for the models}
}
}

\examples{

data(theo.saemix)

saemix.data<-saemixData(name.data=theo.saemix,header=TRUE,sep=" ",na=NA, 
  name.group=c("Id"),name.predictors=c("Dose","Time"),
  name.response=c("Concentration"),name.covariates=c("Weight","Sex"),
  units=list(x="hr",y="mg/L",covariates=c("kg","-")), name.X="Time")

model1cpt<-function(psi,id,xidep) { 
	  dose<-xidep[,1]
	  tim<-xidep[,2]  
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}

saemix.model<-saemixModel(model=model1cpt,
  description="One-compartment model with first-order absorption", 
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")

saemix.options<-list(algorithm=c(1,0,0),seed=632545,save=FALSE,save.graphs=FALSE, 
displayProgress=FALSE)

# Not run (strict time constraints for CRAN)
\donttest{
saemix.fit<-saemix(saemix.model,saemix.data,saemix.options)
psi(saemix.fit)
phi(saemix.fit)
eta(saemix.fit,type="mean")
}

}
\references{
E Comets, A Lavenu, M Lavielle M (2017). Parameter estimation in nonlinear mixed effect models using saemix,
an R implementation of the SAEM algorithm. Journal of Statistical Software, 80(3):1-41.

E Kuhn, M Lavielle (2005). Maximum likelihood estimation in nonlinear mixed effects models.
Computational Statistics and Data Analysis, 49(4):1020-1038.

E Comets, A Lavenu, M Lavielle (2011). SAEMIX, an R version of the SAEM algorithm. 20th meeting of the
Population Approach Group in Europe, Athens, Greece, Abstr 2173.
}
\seealso{
\code{\link{SaemixData}},\code{\link{SaemixModel}},
\code{\link{SaemixObject}}, \code{\link{saemixControl}},
\code{\link{plot.saemix}}
}
\author{
Emmanuelle Comets \href{mailto:emmanuelle.comets@inserm.fr}{emmanuelle.comets@inserm.fr}, Audrey Lavenu,
Marc Lavielle.
}
\keyword{methods}
